package com.turbospaces.rpc;

import java.util.Objects;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.util.concurrent.FutureCallback;
import com.turbospaces.cfg.ApplicationProperties;

public class FutureCallbackWrapper<T> implements FutureCallback<T> {
    private final FutureCallback<T> callback;
    private final ApplicationProperties props;
    private final Thread thread;

    public FutureCallbackWrapper(ApplicationProperties props, FutureCallback<T> callback) {
        this.props = props;
        this.callback = Objects.requireNonNull(callback);
        this.thread = Thread.currentThread();
    }
    @Override
    public void onSuccess(T result) {
        runGuard();
        callback.onSuccess(result);
    }
    @Override
    public void onFailure(Throwable t) {
        runGuard();
        callback.onFailure(t);
    }
    private void runGuard() {
        Thread currentThread = Thread.currentThread();
        String name = callback.getClass().getSimpleName();

        //
        // ~ we should not execute callback in same thread as it was submitted
        //
        if (thread.equals(currentThread)) {
            if (props.isDevMode()) {
                String reason = "detected callback execution abuse in: " + name;
                IllegalStateException err = new IllegalStateException(reason);
                err.fillInStackTrace();

                throw err;
            }

            Logger log = LoggerFactory.getLogger(name);
            log.error("detected callback execution of {} in origin: {}", name, thread);
        }
    }
}
