/*
 * Decompiled with CFR 0.152.
 */
package reactor.blockhound.integration;

import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.blockhound.integration.DefaultBlockHoundIntegration;

class DefaultBlockHoundIntegrationTest {
    private static final Logger log = LoggerFactory.getLogger(DefaultBlockHoundIntegrationTest.class);

    DefaultBlockHoundIntegrationTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void latch() throws Throwable {
        MockCloud mockCloud = MockCloud.newMock();
        ApplicationConfig cfg = mockCloud.build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        cfg.setLocalProperty(props.APP_BLOCKHOUND_ENABLED.getKey(), (Object)true);
        SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        final MutableBoolean failed = new MutableBoolean(false);
        final CountDownLatch executed = new CountDownLatch(1);
        try {
            bootstrap.run(new String[0]);
            bootstrap.platform("system").execute(new Runnable(){

                @Override
                public void run() {
                    CountDownLatch latch = new CountDownLatch(1);
                    DefaultBlockHoundIntegration.FLAG.set(true);
                    try {
                        log.info("about to await in blocking manner ...");
                        latch.await(1L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException err) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Throwable err) {
                        log.atError().setCause(err).log();
                        failed.setTrue();
                    }
                    finally {
                        DefaultBlockHoundIntegration.FLAG.remove();
                        executed.countDown();
                    }
                }
            });
            executed.await();
            Assertions.assertTrue((boolean)failed.getValue());
        }
        finally {
            bootstrap.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void http() throws Throwable {
        MockCloud mockCloud = MockCloud.newMock();
        ApplicationConfig cfg = mockCloud.build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        cfg.setLocalProperty(props.APP_BLOCKHOUND_ENABLED.getKey(), (Object)true);
        final CloseableHttpClient httpClient = HttpClients.createDefault();
        SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        final MutableBoolean failed = new MutableBoolean(false);
        final CountDownLatch executed = new CountDownLatch(1);
        try {
            bootstrap.run(new String[0]);
            bootstrap.platform("mock").execute(new Runnable(){

                @Override
                public void run() {
                    DefaultBlockHoundIntegration.FLAG.set(true);
                    try {
                        log.info("about to make blocking http call ...");
                        HttpGet req = new HttpGet("https://google.com?q=DDOS");
                        CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)req);
                        if (resp != null) {
                            resp.close();
                        }
                    }
                    catch (Throwable err) {
                        log.atError().setCause(err).log();
                        failed.setTrue();
                    }
                    finally {
                        DefaultBlockHoundIntegration.FLAG.remove();
                        executed.countDown();
                    }
                }
            });
            executed.await();
            Assertions.assertTrue((boolean)failed.getValue());
        }
        finally {
            httpClient.close();
            bootstrap.shutdown();
        }
    }
}

