/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.properties;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.properties.BootstrapPropertiesParser;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class BootstrapPropertiesParserTest {
    private BootstrapPropertiesParser unit;

    BootstrapPropertiesParserTest() {
    }

    @BeforeEach
    void setUp() throws Throwable {
        this.unit = new BootstrapPropertiesParser();
        this.unit.setBootstrap(BootstrapPropertiesParserTest.bootstrap());
    }

    private static Bootstrap bootstrap() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.cfg().setDefaultProperties(BootstrapPropertiesParserTest.readBrandsProperties());
        bootstrap.run(new String[0]);
        return bootstrap;
    }

    private static Properties readBrandsProperties() throws IOException {
        Properties properties = new Properties();
        properties.load(BootstrapPropertiesParserTest.class.getResourceAsStream("/brands.properties"));
        return properties;
    }

    @Test
    void parse() {
        List brands = this.unit.parse("brands", Brand::fromProperties);
        Assertions.assertEquals((int)3, (int)brands.size());
        Brand brand1 = new Brand("brand1", "brand1", "brand1.com", true);
        Brand brand2 = new Brand("brand2", "brand2", "brand2.com", false);
        Brand brand3 = new Brand("brand3", "brand3", "brand3.com", false);
        Assertions.assertArrayEquals((Object[])new Brand[]{brand1, brand2, brand3}, (Object[])brands.toArray());
    }

    public record Brand(String name, String code, String domain, boolean active) {
        public static Brand fromProperties(String name, Map<String, String> properties) {
            return new Brand(name, properties.get("code"), properties.get("domain"), Boolean.parseBoolean(properties.get("active")));
        }
    }
}

