/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.google.common.base.Joiner;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.ups.PlainServiceInfo;
import com.turbospaces.ups.RawServiceInfo;
import com.turbospaces.ups.UPSs;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.service.BaseServiceInfo;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.cloud.service.common.PostgresqlServiceInfo;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import uk.org.webcompere.systemstubs.environment.EnvironmentVariables;
import uk.org.webcompere.systemstubs.jupiter.SystemStub;
import uk.org.webcompere.systemstubs.jupiter.SystemStubsExtension;

@ExtendWith(value={SystemStubsExtension.class})
class UPSsTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @SystemStub
    private EnvironmentVariables envVariables;

    UPSsTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void hierarchicalScoped() throws Throwable {
        String scope1 = "scope1";
        String scope2 = "scope2";
        String scope3 = "scope3";
        String upsName = PlatformUtil.randomUUID().toString();
        BaseServiceInfo ups = new BaseServiceInfo(upsName);
        BaseServiceInfo ups1 = new BaseServiceInfo(scope1 + "-" + upsName);
        BaseServiceInfo ups1_2 = new BaseServiceInfo(Joiner.on((String)"-").join((Object)scope1, (Object)scope2, new Object[0]) + "-" + upsName);
        BaseServiceInfo ups1_2_3 = new BaseServiceInfo(Joiner.on((String)"-").join((Object)scope1, (Object)scope2, new Object[]{scope3}) + "-" + upsName);
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.run(new String[0]);
        try {
            CountDownLatch executed = new CountDownLatch(1);
            new Thread(() -> {
                bootstrap.addUps((ServiceInfo)ups);
                bootstrap.addUps((ServiceInfo)ups1);
                bootstrap.addUps((ServiceInfo)ups1_2);
                bootstrap.addUps((ServiceInfo)ups1_2_3);
                executed.countDown();
            }).start();
            Assertions.assertTrue((boolean)executed.await(30L, TimeUnit.SECONDS));
            Assertions.assertEquals((Object)UPSs.findRequiredScopedServiceInfoByName((Bootstrap)bootstrap, (String)upsName, (String[])new String[]{scope1, scope2, scope3}), (Object)ups1_2_3);
            Assertions.assertEquals((Object)UPSs.findRequiredScopedServiceInfoByName((Bootstrap)bootstrap, (String)upsName, (String[])new String[]{scope1, scope2, scope3, "invalidScope"}), (Object)ups1_2_3);
            Assertions.assertEquals((Object)UPSs.findRequiredScopedServiceInfoByName((Bootstrap)bootstrap, (String)upsName, (String[])new String[]{scope1, scope2, scope3, null}), (Object)ups1_2_3);
            Assertions.assertEquals((Object)UPSs.findRequiredScopedServiceInfoByName((Bootstrap)bootstrap, (String)upsName, (String[])new String[]{scope1, scope2}), (Object)ups1_2);
            Assertions.assertEquals((Object)UPSs.findRequiredScopedServiceInfoByName((Bootstrap)bootstrap, (String)upsName, (String[])new String[]{scope1.toUpperCase(), scope2, "invalidScope"}), (Object)ups1_2);
            Assertions.assertEquals((Object)UPSs.findRequiredScopedServiceInfoByName((Bootstrap)bootstrap, (String)upsName, (String[])new String[]{scope1, scope2, "invalidScope"}), (Object)ups1_2);
            Assertions.assertEquals((Object)UPSs.findRequiredScopedServiceInfoByName((Bootstrap)bootstrap, (String)upsName, (String[])new String[]{scope1, scope2, null}), (Object)ups1_2);
            Assertions.assertEquals((Object)UPSs.findRequiredScopedServiceInfoByName((Bootstrap)bootstrap, (String)upsName, (String[])new String[]{scope1}), (Object)ups1);
            Assertions.assertEquals((Object)UPSs.findRequiredScopedServiceInfoByName((Bootstrap)bootstrap, (String)upsName, (String[])new String[]{scope1.toUpperCase()}), (Object)ups1);
            Assertions.assertEquals((Object)UPSs.findRequiredScopedServiceInfoByName((Bootstrap)bootstrap, (String)upsName, (String[])new String[]{scope1, "invalidScope"}), (Object)ups1);
            Assertions.assertEquals((Object)UPSs.findRequiredScopedServiceInfoByName((Bootstrap)bootstrap, (String)upsName, (String[])new String[0]), (Object)ups);
            Assertions.assertEquals((Object)UPSs.findRequiredScopedServiceInfoByName((Bootstrap)bootstrap, (String)upsName, (String[])new String[]{null, null}), (Object)ups);
            Assertions.assertEquals((Object)UPSs.findRequiredScopedServiceInfoByName((Bootstrap)bootstrap, (String)upsName, (String[])new String[]{"invalidScope"}), (Object)ups);
            Assertions.assertFalse((boolean)UPSs.findScopedServiceInfoByName((Bootstrap)bootstrap, (String)"invalidUpsName", (String[])new String[0]).isPresent());
        }
        finally {
            bootstrap.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testEnvScopedSecret() throws Throwable {
        String env1 = "qa";
        String env2 = "qa1";
        String env3 = "qa2";
        String scope1 = "scope1";
        String scope2 = "scope2";
        String upsName = PlatformUtil.randomUUID().toString();
        BaseServiceInfo ups = new BaseServiceInfo(upsName);
        BaseServiceInfo ups1 = new BaseServiceInfo(env1 + "-" + upsName);
        BaseServiceInfo ups2 = new BaseServiceInfo(env2 + "-" + upsName);
        BaseServiceInfo ups3 = new BaseServiceInfo(env3 + "-" + upsName);
        BaseServiceInfo ups3s1 = new BaseServiceInfo(env3 + "-" + scope1 + "-" + upsName);
        BaseServiceInfo upss2 = new BaseServiceInfo(scope2 + "-" + upsName);
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.run(new String[0]);
        try {
            CountDownLatch executed = new CountDownLatch(1);
            new Thread(() -> {
                bootstrap.addUps((ServiceInfo)ups);
                bootstrap.addUps((ServiceInfo)ups1);
                bootstrap.addUps((ServiceInfo)ups2);
                bootstrap.addUps((ServiceInfo)ups3);
                bootstrap.addUps((ServiceInfo)ups3s1);
                bootstrap.addUps((ServiceInfo)upss2);
                executed.countDown();
            }).start();
            Assertions.assertTrue((boolean)executed.await(30L, TimeUnit.SECONDS));
            Assertions.assertEquals((Object)UPSs.findRequiredServiceInfoByName((Bootstrap)bootstrap, (String)upsName), (Object)ups);
            this.envVariables.set("STAGE", env1);
            Assertions.assertEquals((Object)UPSs.findRequiredServiceInfoByName((Bootstrap)bootstrap, (String)upsName), (Object)ups1);
            this.envVariables.set("STAGE", env2);
            Assertions.assertEquals((Object)UPSs.findRequiredServiceInfoByName((Bootstrap)bootstrap, (String)upsName), (Object)ups2);
            this.envVariables.set("STAGE", env3);
            Assertions.assertEquals((Object)UPSs.findRequiredServiceInfoByName((Bootstrap)bootstrap, (String)upsName), (Object)ups3);
            Assertions.assertEquals((Object)UPSs.findRequiredScopedServiceInfoByName((Bootstrap)bootstrap, (String)upsName, (String[])new String[]{scope1}), (Object)ups3s1);
            Assertions.assertEquals((Object)UPSs.findRequiredScopedServiceInfoByName((Bootstrap)bootstrap, (String)upsName, (String[])new String[]{scope2}), (Object)upss2);
        }
        finally {
            bootstrap.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void works() throws Throwable {
        final String ups = PlatformUtil.randomUUID().toString();
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        final SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.run(new String[0]);
        try {
            try {
                bootstrap.serviceInfoByName(ups).blockFirst(Duration.ofMillis(1L));
                Assertions.fail();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            Scheduler scheduler = Schedulers.fromExecutor((Executor)bootstrap.globalPlatform());
            final CountDownLatch latch = new CountDownLatch(1);
            bootstrap.serviceInfoByName(ups).subscribeOn(scheduler).subscribe((Consumer)new Consumer<ServiceInfo>(){

                @Override
                public void accept(ServiceInfo t) {
                    latch.countDown();
                }
            });
            final CountDownLatch executed = new CountDownLatch(1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    bootstrap.addUps((ServiceInfo)new PlainServiceInfo(ups, "dns:///api.google.com"));
                    executed.countDown();
                }
            }).start();
            Assertions.assertTrue((boolean)executed.await(30L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
            PlainServiceInfo si = (PlainServiceInfo)bootstrap.cloud().getServiceInfo(ups);
            Assertions.assertNotNull((Object)si);
            Assertions.assertEquals((Object)"dns", (Object)si.getScheme());
            Assertions.assertEquals((Object)"api.google.com", (Object)si.getPath());
            Assertions.assertEquals((Object)"dns:///api.google.com", (Object)si.getUri());
            bootstrap.removeUps(ups);
            Assertions.assertTrue((boolean)bootstrap.cloud().getServiceInfos().isEmpty());
            try {
                bootstrap.serviceInfoByName(ups).timeout(Duration.ofMillis(1L)).hasElements().block();
                Assertions.fail();
            }
            catch (Exception err) {
                Assertions.assertTrue((boolean)ExceptionUtils.getRootCause((Throwable)err).getClass().equals(TimeoutException.class));
            }
        }
        finally {
            bootstrap.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void scoped() throws Throwable {
        final String scope = Long.toString(System.currentTimeMillis());
        final String ups = PlatformUtil.randomUUID().toString();
        final UUID uuid = PlatformUtil.randomUUID();
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        final SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.run(new String[0]);
        try {
            try {
                bootstrap.scopedServiceInfoByName(scope, ups).blockFirst(Duration.ofMillis(1L));
                Assertions.fail();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            Scheduler scheduler = Schedulers.fromExecutor((Executor)bootstrap.globalPlatform());
            final CountDownLatch latch = new CountDownLatch(2);
            bootstrap.scopedServiceInfoByName(scope, ups).subscribeOn(scheduler).subscribe((Consumer)new Consumer<ServiceInfo>(){

                @Override
                public void accept(ServiceInfo t) {
                    latch.countDown();
                }
            });
            final CountDownLatch executed = new CountDownLatch(1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(ups));
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(uuid + "-" + ups));
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(scope + "-" + ups));
                    executed.countDown();
                }
            }).start();
            Assertions.assertTrue((boolean)executed.await(30L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
            Assertions.assertNotNull((Object)bootstrap.cloud().getServiceInfo(ups));
            Assertions.assertNotNull((Object)bootstrap.cloud().getServiceInfo(scope + "-" + ups));
            bootstrap.removeUps(ups);
            bootstrap.removeUps(scope + "-" + ups);
            bootstrap.removeUps(uuid + "-" + ups);
            Assertions.assertTrue((boolean)bootstrap.cloud().getServiceInfos().isEmpty());
            try {
                bootstrap.serviceInfoByName(ups).timeout(Duration.ofMillis(1L)).hasElements().block();
                Assertions.fail();
            }
            catch (Exception err) {
                Assertions.assertTrue((boolean)ExceptionUtils.getRootCause((Throwable)err).getClass().equals(TimeoutException.class));
            }
        }
        finally {
            bootstrap.shutdown();
        }
    }

    @Test
    void plainServiceInfo() {
        PlainServiceInfo si1 = new PlainServiceInfo("key", "https://a.b/c?d=e");
        PlainServiceInfo si2 = new PlainServiceInfo("key", "https://a.b/c?d=e1&d=e2");
        PlainServiceInfo si3 = new PlainServiceInfo("key", "https://a.b?d=e");
        Flux flux = Flux.fromIterable(Arrays.asList(si1, si1, si1, si2, si3)).log().distinctUntilChanged(Function.identity(), (BiPredicate)new BiPredicate<PlainServiceInfo, PlainServiceInfo>(){

            @Override
            public boolean test(PlainServiceInfo t, PlainServiceInfo u) {
                while (true) {
                    try {
                        return UPSs.isEquals((ServiceInfo)t, (ServiceInfo)u);
                    }
                    catch (IOException err) {
                        ExceptionUtils.wrapAndThrow((Throwable)err);
                        continue;
                    }
                    break;
                }
            }
        }).distinctUntilChanged(Function.identity(), (BiPredicate)new BiPredicate<PlainServiceInfo, PlainServiceInfo>(){

            @Override
            public boolean test(PlainServiceInfo s1, PlainServiceInfo s2) {
                while (true) {
                    try {
                        return UPSs.hashCode((ServiceInfo)s1) == UPSs.hashCode((ServiceInfo)s2);
                    }
                    catch (IOException err) {
                        ExceptionUtils.wrapAndThrow((Throwable)err);
                        continue;
                    }
                    break;
                }
            }
        });
        final AtomicLong l = new AtomicLong();
        flux.subscribe((Consumer)new Consumer<PlainServiceInfo>(){

            @Override
            public void accept(PlainServiceInfo t) {
                UPSsTest.this.logger.info("accepting UPS: {}", (Object)t);
                l.incrementAndGet();
            }
        });
        flux.subscribe();
        Assertions.assertEquals((long)3L, (long)l.get());
    }

    @Test
    void rawServiceInfo() {
        RawServiceInfo si1 = new RawServiceInfo("key", "a".getBytes());
        RawServiceInfo si2 = new RawServiceInfo("key", "b".getBytes());
        RawServiceInfo si3 = new RawServiceInfo("key", "c".getBytes());
        Flux flux = Flux.fromIterable(Arrays.asList(si1, si1, si1, si2, si2, si3)).log().distinctUntilChanged(Function.identity(), (BiPredicate)new BiPredicate<RawServiceInfo, RawServiceInfo>(){

            @Override
            public boolean test(RawServiceInfo t, RawServiceInfo u) {
                while (true) {
                    try {
                        return UPSs.isEquals((ServiceInfo)t, (ServiceInfo)u);
                    }
                    catch (IOException err) {
                        ExceptionUtils.wrapAndThrow((Throwable)err);
                        continue;
                    }
                    break;
                }
            }
        }).distinctUntilChanged(Function.identity(), (BiPredicate)new BiPredicate<RawServiceInfo, RawServiceInfo>(){

            @Override
            public boolean test(RawServiceInfo s1, RawServiceInfo s2) {
                while (true) {
                    try {
                        return UPSs.hashCode((ServiceInfo)s1) == UPSs.hashCode((ServiceInfo)s2);
                    }
                    catch (IOException err) {
                        ExceptionUtils.wrapAndThrow((Throwable)err);
                        continue;
                    }
                    break;
                }
            }
        });
        final AtomicLong l = new AtomicLong();
        flux.subscribe((Consumer)new Consumer<RawServiceInfo>(){

            @Override
            public void accept(RawServiceInfo t) {
                UPSsTest.this.logger.info("accepting UPS: {}", (Object)t.getId());
                l.incrementAndGet();
            }
        });
        flux.subscribe();
        Assertions.assertEquals((long)3L, (long)l.get());
    }

    @Test
    void pg() {
        PostgresqlServiceInfo si1 = new PostgresqlServiceInfo("key", "postgres://app_owner:app_owner@127.0.0.1:5432/defaultdb1");
        PostgresqlServiceInfo si2 = new PostgresqlServiceInfo("key", "postgres://app_owner:app_owner2@127.0.0.1:5432/defaultdb");
        PostgresqlServiceInfo si3 = new PostgresqlServiceInfo("key", "postgres://app_owner:app_owner@127.0.0.3:5432/defaultdb");
        Flux flux = Flux.fromIterable(Arrays.asList(si1, si1, si1, si2, si2, si3)).log().distinctUntilChanged(Function.identity(), (t, u) -> {
            while (true) {
                try {
                    return UPSs.isEquals((ServiceInfo)t, (ServiceInfo)u);
                }
                catch (IOException err) {
                    ExceptionUtils.wrapAndThrow((Throwable)err);
                    continue;
                }
                break;
            }
        }).distinctUntilChanged(Function.identity(), (BiPredicate)new BiPredicate<PostgresqlServiceInfo, PostgresqlServiceInfo>(){

            @Override
            public boolean test(PostgresqlServiceInfo s1, PostgresqlServiceInfo s2) {
                while (true) {
                    try {
                        return UPSs.hashCode((ServiceInfo)s1) == UPSs.hashCode((ServiceInfo)s2);
                    }
                    catch (IOException err) {
                        ExceptionUtils.wrapAndThrow((Throwable)err);
                        continue;
                    }
                    break;
                }
            }
        });
        final AtomicLong l = new AtomicLong();
        flux.subscribe((Consumer)new Consumer<PostgresqlServiceInfo>(){

            @Override
            public void accept(PostgresqlServiceInfo t) {
                UPSsTest.this.logger.info("accepting UPS: {}", (Object)t.getId());
                l.incrementAndGet();
            }
        });
        flux.subscribe();
        Assertions.assertEquals((long)3L, (long)l.get());
    }
}

