package com.turbospaces.properties;

import static org.junit.jupiter.api.Assertions.assertArrayEquals;
import static org.junit.jupiter.api.Assertions.assertEquals;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;

class BootstrapPropertiesParserTest {

    private BootstrapPropertiesParser unit;

    @BeforeEach
    void setUp() throws Throwable {
        unit = new BootstrapPropertiesParser();
        unit.setBootstrap(bootstrap());
    }

    private static Bootstrap bootstrap() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.cfg().setDefaultProperties(readBrandsProperties());
        bootstrap.run();

        return bootstrap;
    }

    private static Properties readBrandsProperties() throws IOException {
        Properties properties = new Properties();
        properties.load(BootstrapPropertiesParserTest.class.getResourceAsStream("/brands.properties"));

        return properties;
    }

    public record Brand(String name, String code, String domain, boolean active) {

        public static Brand fromProperties(String name, Map<String, String> properties) {
            return new Brand(name, properties.get("code"), properties.get("domain"), Boolean.parseBoolean(properties.get("active")));
        }
    }

    @Test
    void parse() {
        List<Brand> brands = unit.parse("brands", Brand::fromProperties);

        assertEquals(3, brands.size());

        Brand brand1 = new Brand("brand1", "brand1", "brand1.com", true);
        Brand brand2 = new Brand("brand2", "brand2", "brand2.com", false);
        Brand brand3 = new Brand("brand3", "brand3", "brand3.com", false);
        assertArrayEquals(new Brand[] {brand1, brand2, brand3}, brands.toArray());
    }
}
