/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.rpc;

import api.v1.ApiFactory;
import api.v1.ApplicationException;
import api.v1.Headers;
import api.v1.MockApiFactory;
import api.v1.MockResponseStatusFacade;
import api.v1.RequestWrapper;
import com.google.common.io.ByteSource;
import com.google.protobuf.Any;
import com.google.protobuf.Internal;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.turbospaces.api.NoOpStackTracer;
import com.turbospaces.api.facade.DefaultRequestWrapperFacade;
import com.turbospaces.api.facade.RequestWrapperFacade;
import com.turbospaces.api.jpa.CompositeStackTracer;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.dispatch.EmbeddedTransactionalRequest;
import com.turbospaces.dispatch.SafeRequestHandler;
import com.turbospaces.dispatch.TransactionalRequest;
import com.turbospaces.dispatch.TransactionalRequestHandler;
import com.turbospaces.dispatch.TransactionalRequestOutcome;
import com.turbospaces.dispatch.WorkerCompletableTask;
import com.turbospaces.executor.WorkUnit;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.search.RequiredSearch;
import io.opentracing.Span;
import io.opentracing.noop.NoopSpan;
import io.vavr.CheckedRunnable;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SafeRequestHandlerTest {
    private static final Logger log = LoggerFactory.getLogger(SafeRequestHandlerTest.class);
    CountDownLatch latch = new CountDownLatch(1);
    String key = RandomStringUtils.randomAlphanumeric((int)4);
    WorkUnit unit = new WorkUnit(){

        public String topic() {
            return "junit";
        }

        public long timestamp() {
            return System.currentTimeMillis();
        }

        public byte[] key() {
            return SafeRequestHandlerTest.this.key.getBytes();
        }

        public ByteSource value() {
            return ByteSource.empty();
        }
    };

    SafeRequestHandlerTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void works() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        final SimpleBootstrap boot = new SimpleBootstrap(props);
        boot.run(new String[0]);
        try {
            Timestamp req = Timestamp.newBuilder().setSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
            MockApiFactory apiFactory = new MockApiFactory();
            DefaultRequestWrapperFacade reqw = new DefaultRequestWrapperFacade(apiFactory.eventTemplate(), RequestWrapper.newBuilder().setHeaders(Headers.newBuilder().setMessageId(PlatformUtil.randomUUID().toString())).setBody(Any.pack((Message)req)));
            final Semaphore semaphore = new Semaphore(0);
            final CheckedRunnable task1 = (CheckedRunnable)Mockito.mock(CheckedRunnable.class);
            final CheckedRunnable task2 = (CheckedRunnable)Mockito.mock(CheckedRunnable.class);
            SafeRequestHandler handler = new SafeRequestHandler((RequestWrapperFacade)reqw, (ApiFactory)apiFactory, (CompositeStackTracer)new NoOpStackTracer(), (Span)NoopSpan.INSTANCE, this.unit, (TransactionalRequest)new EmbeddedTransactionalRequest(Timestamp.class, (Message.Builder)Timestamp.newBuilder(), this.unit, (RequestWrapperFacade)reqw, this.latch), (TransactionalRequestHandler)new TransactionalRequestHandler<Timestamp, Timestamp.Builder>(){

                public boolean actorIsRequired() {
                    return false;
                }

                public boolean isImmediateAcknowledge() {
                    return false;
                }

                public void apply(TransactionalRequest<Timestamp, Timestamp.Builder> cmd) throws Exception {
                    cmd.addMetricTag("provider", Long.toString(System.currentTimeMillis()));
                    cmd.replyWhen(boot.globalPlatform().submit(() -> {
                        semaphore.acquire();
                        task1.run();
                    }));
                    cmd.replyWhen(boot.globalPlatform().submit(() -> {
                        semaphore.acquire();
                        task2.run();
                    }));
                }
            });
            handler.setBootstrap((Bootstrap)boot);
            WorkerCompletableTask task = handler.get();
            handler.run();
            ((CheckedRunnable)Mockito.verify((Object)task1, (VerificationMode)Mockito.never())).run();
            ((CheckedRunnable)Mockito.verify((Object)task2, (VerificationMode)Mockito.never())).run();
            semaphore.release(2);
            TransactionalRequestOutcome operationOutcome = task.get();
            ((CheckedRunnable)Mockito.verify((Object)task1)).run();
            ((CheckedRunnable)Mockito.verify((Object)task2)).run();
            RequiredSearch search = boot.meterRegistry().get("dispatcher");
            Timer timer = search.timer();
            Measurement next = (Measurement)timer.measure().iterator().next();
            log.info(next.toString());
            Assertions.assertTrue((boolean)operationOutcome.getNotifications().isEmpty());
            Assertions.assertTrue((boolean)operationOutcome.getEventStream().isEmpty());
        }
        finally {
            boot.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void applicationExceptionInMain() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap boot = new SimpleBootstrap(props);
        boot.run(new String[0]);
        try {
            Timestamp req = Timestamp.newBuilder().setSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
            MockApiFactory apiFactory = new MockApiFactory();
            DefaultRequestWrapperFacade reqw = new DefaultRequestWrapperFacade(apiFactory.eventTemplate(), RequestWrapper.newBuilder().setHeaders(Headers.newBuilder().setMessageId(PlatformUtil.randomUUID().toString())).setBody(Any.pack((Message)req)));
            SafeRequestHandler handler = new SafeRequestHandler((RequestWrapperFacade)reqw, (ApiFactory)apiFactory, (CompositeStackTracer)new NoOpStackTracer(), (Span)NoopSpan.INSTANCE, this.unit, (TransactionalRequest)new EmbeddedTransactionalRequest(Timestamp.class, (Message.Builder)Timestamp.newBuilder(), this.unit, (RequestWrapperFacade)reqw, this.latch), (TransactionalRequestHandler)new TransactionalRequestHandler<Timestamp, Timestamp.Builder>(){

                public boolean actorIsRequired() {
                    return false;
                }

                public boolean isImmediateAcknowledge() {
                    return false;
                }

                public void apply(TransactionalRequest<Timestamp, Timestamp.Builder> cmd) throws Exception {
                    throw ApplicationException.of((String)"unable to find", (Internal.EnumLite)MockResponseStatusFacade.Code.ERR_NOT_FOUND, (Object[])new Object[0]);
                }
            });
            handler.setBootstrap((Bootstrap)boot);
            WorkerCompletableTask task = handler.get();
            handler.run();
            TransactionalRequestOutcome operationOutcome = task.get();
            RequiredSearch search = boot.meterRegistry().get("dispatcher");
            Timer timer = search.timer();
            Measurement next = (Measurement)timer.measure().iterator().next();
            log.info(next.toString());
            Assertions.assertTrue((boolean)operationOutcome.getReply().status().isNotFound());
        }
        finally {
            boot.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void exceptionInReplyWhen() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        final SimpleBootstrap boot = new SimpleBootstrap(props);
        boot.run(new String[0]);
        try {
            Timestamp req = Timestamp.newBuilder().setSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
            MockApiFactory apiFactory = new MockApiFactory();
            DefaultRequestWrapperFacade reqw = new DefaultRequestWrapperFacade(apiFactory.eventTemplate(), RequestWrapper.newBuilder().setHeaders(Headers.newBuilder().setMessageId(PlatformUtil.randomUUID().toString())).setBody(Any.pack((Message)req)));
            SafeRequestHandler handler = new SafeRequestHandler((RequestWrapperFacade)reqw, (ApiFactory)apiFactory, (CompositeStackTracer)new NoOpStackTracer(), (Span)NoopSpan.INSTANCE, this.unit, (TransactionalRequest)new EmbeddedTransactionalRequest(Timestamp.class, (Message.Builder)Timestamp.newBuilder(), this.unit, (RequestWrapperFacade)reqw, this.latch), (TransactionalRequestHandler)new TransactionalRequestHandler<Timestamp, Timestamp.Builder>(){

                public boolean actorIsRequired() {
                    return true;
                }

                public boolean isImmediateAcknowledge() {
                    return false;
                }

                public void apply(TransactionalRequest<Timestamp, Timestamp.Builder> cmd) throws Exception {
                    cmd.replyWhen(boot.globalPlatform().submit((Callable)new Callable<Timestamp>(){

                        @Override
                        public Timestamp call() throws Exception {
                            throw new RuntimeException("unable to complete");
                        }
                    }));
                }
            });
            handler.setBootstrap((Bootstrap)boot);
            WorkerCompletableTask task = handler.get();
            handler.run();
            TransactionalRequestOutcome operationOutcome = task.get();
            Assertions.assertTrue((boolean)operationOutcome.getNotifications().isEmpty());
            Assertions.assertTrue((boolean)operationOutcome.getReply().status().isSystem());
        }
        finally {
            boot.shutdown();
        }
    }
}

