/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.executor;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.executor.DefaultPlatformExecutorService;
import com.turbospaces.executor.ThreadPoolContextWorker;
import io.micrometer.core.instrument.MeterRegistry;
import io.vavr.CheckedRunnable;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultPlatformExecutorServiceTest {
    private static final Logger log = LoggerFactory.getLogger(DefaultPlatformExecutorServiceTest.class);

    DefaultPlatformExecutorServiceTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void works() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.run(new String[0]);
        try {
            int tasks = 1024;
            final CountDownLatch latch = new CountDownLatch(tasks);
            DefaultPlatformExecutorService executor = new DefaultPlatformExecutorService(props, (MeterRegistry)bootstrap.meterRegistry(), "main", 0, tasks);
            executor.afterPropertiesSet();
            ThreadPoolContextWorker worker = new ThreadPoolContextWorker(props, (MeterRegistry)bootstrap.meterRegistry(), (ExecutorService)executor);
            worker.afterPropertiesSet();
            final AtomicInteger success = new AtomicInteger();
            final AtomicInteger failure = new AtomicInteger();
            try {
                int i = 0;
                while (i < tasks) {
                    final int temp = i++;
                    FluentFuture.from((ListenableFuture)worker.submit(new CheckedRunnable(){

                        public void run() throws Throwable {
                            Uninterruptibles.sleepUninterruptibly((Duration)Duration.ofMillis(1L));
                            if (temp % 2 == 0) {
                                throw new IllegalArgumentException();
                            }
                        }
                    })).addCallback((FutureCallback)new FutureCallback<Object>(){

                        public void onSuccess(Object result) {
                            success.incrementAndGet();
                            latch.countDown();
                        }

                        public void onFailure(Throwable t) {
                            failure.incrementAndGet();
                            Assertions.assertInstanceOf(IllegalArgumentException.class, (Object)t);
                            latch.countDown();
                        }
                    }, MoreExecutors.directExecutor());
                }
                Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
                Assertions.assertEquals((int)success.get(), (int)failure.get());
            }
            finally {
                executor.destroy();
            }
        }
        finally {
            bootstrap.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void rejected() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.run(new String[0]);
        try {
            int tasks = 1024;
            final CountDownLatch latch = new CountDownLatch(tasks);
            DefaultPlatformExecutorService executor = new DefaultPlatformExecutorService(props, (MeterRegistry)bootstrap.meterRegistry(), "main", 0, 4);
            executor.afterPropertiesSet();
            final AtomicInteger failure = new AtomicInteger();
            try {
                for (int i = 0; i < tasks; ++i) {
                    FluentFuture.from((ListenableFuture)executor.submit(new CheckedRunnable(){

                        public void run() throws Throwable {
                            Uninterruptibles.sleepUninterruptibly((Duration)Duration.ofMillis(1L));
                        }
                    })).addCallback((FutureCallback)new FutureCallback<Object>(){

                        public void onSuccess(Object result) {
                            latch.countDown();
                        }

                        public void onFailure(Throwable t) {
                            failure.incrementAndGet();
                            Assertions.assertInstanceOf(RejectedExecutionException.class, (Object)t);
                            latch.countDown();
                        }
                    }, MoreExecutors.directExecutor());
                }
                log.info("failed tasks count: {}", (Object)failure.get());
                Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
                Assertions.assertTrue((failure.get() > tasks / 2 ? 1 : 0) != 0);
            }
            finally {
                executor.destroy();
            }
        }
        finally {
            bootstrap.shutdown();
        }
    }
}

