/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.cfg;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.netflix.archaius.api.Property;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.cfg.CloudOptions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ApplicationPropertiesTest {
    @Test
    public void consistentNaming() throws Exception {
        Field[] fields;
        ApplicationConfig cfg = ApplicationConfig.create();
        ApplicationProperties props = new ApplicationProperties(cfg);
        Set whitelist = Arrays.asList(FieldUtils.getAllFields(CloudOptions.class)).stream().map(Field::getName).collect(Collectors.toSet());
        for (Field f : fields = FieldUtils.getAllFields(ApplicationProperties.class)) {
            if (!Modifier.isPublic(f.getModifiers()) || !BooleanUtils.isFalse((Boolean)Modifier.isStatic(f.getModifiers()))) continue;
            Property prop = (Property)FieldUtils.readField((Field)f, (Object)props);
            prop.get();
            String fieldName = f.getName();
            String propKey = prop.getKey().toUpperCase().replaceAll("\\.", "_").replaceAll("-", "_");
            if (!BooleanUtils.isFalse((Boolean)fieldName.equals(propKey)) || !BooleanUtils.isFalse((Boolean)whitelist.contains(fieldName))) continue;
            Assertions.assertEquals((Object)fieldName, (Object)propKey);
        }
    }

    @Test
    public void listOfInts() throws Exception {
        ApplicationConfig cfg = ApplicationConfig.create();
        ApplicationProperties props = new ApplicationProperties(cfg);
        Property p = props.listOfInts("key").orElse((Object)Lists.newArrayList((Object[])new Integer[]{1, 2}));
        Iterator it = ((List)p.get()).iterator();
        int it1 = (Integer)it.next();
        int it2 = (Integer)it.next();
        Assertions.assertEquals((int)1, (int)it1);
        Assertions.assertEquals((int)2, (int)it2);
        cfg.setLocalProperty(p.getKey(), (Object)"1, 3, 5");
        it = ((List)p.get()).iterator();
        it1 = (Integer)it.next();
        it2 = (Integer)it.next();
        int it3 = (Integer)it.next();
        Assertions.assertEquals((int)1, (int)it1);
        Assertions.assertEquals((int)3, (int)it2);
        Assertions.assertEquals((int)5, (int)it3);
        cfg.setLocalProperty(p.getKey(), (Object)"1,5,9");
        it = cfg.getList(p.getKey(), Integer.class).iterator();
        it1 = (Integer)it.next();
        it2 = (Integer)it.next();
        it3 = (Integer)it.next();
        Assertions.assertEquals((int)1, (int)it1);
        Assertions.assertEquals((int)5, (int)it2);
        Assertions.assertEquals((int)9, (int)it3);
    }

    @Test
    public void listOfLong() throws Exception {
        ApplicationConfig cfg = ApplicationConfig.create();
        ApplicationProperties props = new ApplicationProperties(cfg);
        Property p = props.listOfLongs("key").orElse((Object)Lists.newArrayList((Object[])new Long[]{1L, Long.MAX_VALUE}));
        Iterator it = ((List)p.get()).iterator();
        long it1 = (Long)it.next();
        long it2 = (Long)it.next();
        Assertions.assertEquals((long)1L, (long)it1);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)it2);
        cfg.setLocalProperty(p.getKey(), (Object)"1, 3, 9223372036854775807");
        it = ((List)p.get()).iterator();
        it1 = (Long)it.next();
        it2 = (Long)it.next();
        long it3 = (Long)it.next();
        Assertions.assertEquals((long)1L, (long)it1);
        Assertions.assertEquals((long)3L, (long)it2);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)it3);
        cfg.setLocalProperty(p.getKey(), (Object)"1,5,9223372036854775807");
        it = cfg.getList(p.getKey(), Long.class).iterator();
        it1 = (Long)it.next();
        it2 = (Long)it.next();
        it3 = (Long)it.next();
        Assertions.assertEquals((long)1L, (long)it1);
        Assertions.assertEquals((long)5L, (long)it2);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)it3);
    }

    @Test
    public void listOfString() throws Exception {
        ApplicationConfig cfg = ApplicationConfig.create();
        ApplicationProperties props = new ApplicationProperties(cfg);
        Property p = props.listOfStrings("key").orElse((Object)Lists.newArrayList((Object[])new String[]{"k1", "k2"}));
        Iterator it = ((List)p.get()).iterator();
        String it1 = (String)it.next();
        String it2 = (String)it.next();
        Assertions.assertEquals((Object)"k1", (Object)it1);
        Assertions.assertEquals((Object)"k2", (Object)it2);
        cfg.setLocalProperty(p.getKey(), (Object)"k1, k2, k3");
        it = ((List)p.get()).iterator();
        it1 = (String)it.next();
        it2 = (String)it.next();
        String it3 = (String)it.next();
        Assertions.assertEquals((Object)"k1", (Object)it1);
        Assertions.assertEquals((Object)"k2", (Object)it2);
        Assertions.assertEquals((Object)"k3", (Object)it3);
        cfg.setLocalProperty(p.getKey(), (Object)"k1,k2,k5");
        it = cfg.getList(p.getKey(), String.class).iterator();
        it1 = (String)it.next();
        it2 = (String)it.next();
        it3 = (String)it.next();
        Assertions.assertEquals((Object)"k1", (Object)it1);
        Assertions.assertEquals((Object)"k2", (Object)it2);
        Assertions.assertEquals((Object)"k5", (Object)it3);
    }

    @Test
    public void listOfDoubles() throws Exception {
        ApplicationConfig cfg = ApplicationConfig.create();
        ApplicationProperties props = new ApplicationProperties(cfg);
        Property p = props.listOfDoubles("key").orElse((Object)Lists.newArrayList((Object[])new Double[]{1.0, 2.0}));
        Iterator it = ((List)p.get()).iterator();
        Double it1 = (Double)it.next();
        Double it2 = (Double)it.next();
        Assertions.assertEquals((double)1.0, (Double)it1);
        Assertions.assertEquals((double)2.0, (Double)it2);
        cfg.setLocalProperty(p.getKey(), (Object)"1, 2, 3");
        it = ((List)p.get()).iterator();
        it1 = (Double)it.next();
        it2 = (Double)it.next();
        Double it3 = (Double)it.next();
        Assertions.assertEquals((double)1.0, (Double)it1);
        Assertions.assertEquals((double)2.0, (Double)it2);
        Assertions.assertEquals((double)3.0, (Double)it3);
        cfg.setLocalProperty(p.getKey(), (Object)"1,2,5");
        it = cfg.getList(p.getKey(), Double.class).iterator();
        it1 = (Double)it.next();
        it2 = (Double)it.next();
        it3 = (Double)it.next();
        Assertions.assertEquals((double)1.0, (Double)it1);
        Assertions.assertEquals((double)2.0, (Double)it2);
        Assertions.assertEquals((double)5.0, (Double)it3);
    }

    @Test
    public void listOfBigDecimal() throws Exception {
        ApplicationConfig cfg = ApplicationConfig.create();
        ApplicationProperties props = new ApplicationProperties(cfg);
        Property p = props.listOfBigDecimals("key").orElse((Object)Lists.newArrayList((Object[])new BigDecimal[]{BigDecimal.ONE, BigDecimal.ZERO}));
        Iterator it = ((List)p.get()).iterator();
        BigDecimal it1 = (BigDecimal)it.next();
        BigDecimal it2 = (BigDecimal)it.next();
        Assertions.assertEquals((Object)BigDecimal.ONE, (Object)it1);
        Assertions.assertEquals((Object)BigDecimal.ZERO, (Object)it2);
        cfg.setLocalProperty(p.getKey(), (Object)"1, 2, 3");
        it = ((List)p.get()).iterator();
        it1 = (BigDecimal)it.next();
        it2 = (BigDecimal)it.next();
        BigDecimal it3 = (BigDecimal)it.next();
        Assertions.assertEquals((Object)BigDecimal.valueOf(1L), (Object)it1);
        Assertions.assertEquals((Object)BigDecimal.valueOf(2L), (Object)it2);
        Assertions.assertEquals((Object)BigDecimal.valueOf(3L), (Object)it3);
        cfg.setLocalProperty(p.getKey(), (Object)"1,2,5");
        it = cfg.getList(p.getKey(), BigDecimal.class).iterator();
        it1 = (BigDecimal)it.next();
        it2 = (BigDecimal)it.next();
        it3 = (BigDecimal)it.next();
        Assertions.assertEquals((Object)BigDecimal.valueOf(1L), (Object)it1);
        Assertions.assertEquals((Object)BigDecimal.valueOf(2L), (Object)it2);
        Assertions.assertEquals((Object)BigDecimal.valueOf(5L), (Object)it3);
    }

    @Test
    public void listOfLocalDates() throws Exception {
        ApplicationConfig cfg = ApplicationConfig.create();
        ApplicationProperties props = new ApplicationProperties(cfg);
        Property p = props.listOfLocalDates("key").orElse((Object)Lists.newArrayList((Object[])new LocalDate[]{LocalDate.now(ZoneOffset.UTC), LocalDate.now(ZoneOffset.UTC).plusDays(1L)}));
        Iterator it = ((List)p.get()).iterator();
        LocalDate it1 = (LocalDate)it.next();
        LocalDate it2 = (LocalDate)it.next();
        Assertions.assertEquals((Object)LocalDate.now(ZoneOffset.UTC), (Object)it1);
        Assertions.assertEquals((Object)LocalDate.now(ZoneOffset.UTC).plusDays(1L), (Object)it2);
        cfg.setLocalProperty(p.getKey(), (Object)Joiner.on((char)',').join((Object)LocalDate.now(ZoneOffset.UTC).toString(), (Object)LocalDate.now(ZoneOffset.UTC).plusDays(1L), new Object[]{LocalDate.now(ZoneOffset.UTC).plusDays(2L)}));
        it = ((List)p.get()).iterator();
        it1 = (LocalDate)it.next();
        it2 = (LocalDate)it.next();
        LocalDate it3 = (LocalDate)it.next();
        Assertions.assertEquals((Object)LocalDate.now(ZoneOffset.UTC), (Object)it1);
        Assertions.assertEquals((Object)LocalDate.now(ZoneOffset.UTC).plusDays(1L), (Object)it2);
        Assertions.assertEquals((Object)LocalDate.now(ZoneOffset.UTC).plusDays(2L), (Object)it3);
        cfg.setLocalProperty(p.getKey(), (Object)Joiner.on((char)',').join((Object)LocalDate.now(ZoneOffset.UTC).toString(), (Object)LocalDate.now(ZoneOffset.UTC).plusDays(1L), new Object[]{LocalDate.now(ZoneOffset.UTC).plusDays(5L)}));
        it = cfg.getList(p.getKey(), LocalDate.class).iterator();
        it1 = (LocalDate)it.next();
        it2 = (LocalDate)it.next();
        it3 = (LocalDate)it.next();
        Assertions.assertEquals((Object)LocalDate.now(ZoneOffset.UTC), (Object)it1);
        Assertions.assertEquals((Object)LocalDate.now(ZoneOffset.UTC).plusDays(1L), (Object)it2);
        Assertions.assertEquals((Object)LocalDate.now(ZoneOffset.UTC).plusDays(5L), (Object)it3);
    }

    @Test
    public void listOfPatterns() throws Exception {
        ApplicationConfig cfg = ApplicationConfig.create();
        ApplicationProperties props = new ApplicationProperties(cfg);
        final Property p = props.listOfPatterns("key").orElse((Object)Lists.newArrayList((Object[])new Pattern[]{Pattern.compile("[a-zA-Z]{1}"), Pattern.compile("[a-zA-Z]{2}")}));
        Iterator it = ((List)p.get()).iterator();
        Pattern it1 = (Pattern)it.next();
        Pattern it2 = (Pattern)it.next();
        Assertions.assertEquals((Object)"[a-zA-Z]{1}", (Object)it1.pattern());
        Assertions.assertEquals((Object)"[a-zA-Z]{2}", (Object)it2.pattern());
        cfg.setLocalProperty(p.getKey(), (Object)Joiner.on((char)',').join((Object)"[a-zA-Z]{1}", (Object)"[a-zA-Z]{3}", new Object[]{"[a-zA-Z]{5}"}));
        it = ((List)p.get()).iterator();
        it1 = (Pattern)it.next();
        it2 = (Pattern)it.next();
        Pattern it3 = (Pattern)it.next();
        Assertions.assertEquals((Object)"[a-zA-Z]{1}", (Object)it1.pattern());
        Assertions.assertEquals((Object)"[a-zA-Z]{3}", (Object)it2.pattern());
        Assertions.assertEquals((Object)"[a-zA-Z]{5}", (Object)it3.pattern());
        final CountDownLatch l = new CountDownLatch(1);
        p.subscribe((Consumer)new Consumer<List<Pattern>>(){

            @Override
            public void accept(List<Pattern> t) {
                Iterator i = ((List)p.get()).iterator();
                Pattern i1 = (Pattern)i.next();
                Pattern i2 = (Pattern)i.next();
                Pattern i3 = (Pattern)i.next();
                Assertions.assertEquals((Object)"[a-zA-Z]{1}", (Object)i1.pattern());
                Assertions.assertEquals((Object)"[a-zA-Z]{5}", (Object)i2.pattern());
                Assertions.assertEquals((Object)"[a-zA-Z]{9}", (Object)i3.pattern());
                l.countDown();
            }
        });
        cfg.setLocalProperty(p.getKey(), (Object)Joiner.on((char)',').join((Object)"[a-zA-Z]{1}", (Object)"[a-zA-Z]{5}", new Object[]{"[a-zA-Z]{9}"}));
        Assertions.assertTrue((boolean)l.await(1L, TimeUnit.MINUTES));
    }

    @Test
    public void testGetValueWithDefaultsValue() throws Exception {
        ApplicationConfig cfg = ApplicationConfig.create();
        String defaultValue = "default";
        String correctValue = "correct";
        String propertyName = "key";
        cfg.setLocalProperty(propertyName, (Object)"correct");
        String value = (String)cfg.getValueWithDefault(String.class, propertyName, (Object)"default");
        Assertions.assertEquals((Object)"correct", (Object)value);
    }

    @Test
    public void testGetValueWithDefaultsAbsentPropertyDefault() throws Exception {
        ApplicationConfig cfg = ApplicationConfig.create();
        String defaultValue = "default";
        String value = (String)cfg.getValueWithDefault(String.class, "key", (Object)"default");
        Assertions.assertEquals((Object)"default", (Object)value);
    }

    @Test
    public void testGetValueWithDefaultsWrongDefault() throws Exception {
        ApplicationConfig cfg = ApplicationConfig.create();
        String defaultValue = "default";
        String wrongValue = "50kj$%DF";
        String propertyName = "key";
        cfg.setLocalProperty(propertyName, (Object)"50kj$%DF");
        String value = (String)cfg.getValueWithDefault(Integer.TYPE, propertyName, (Object)"default");
        Assertions.assertEquals((Object)"default", (Object)value);
    }
}

