package reactor.blockhound.integration;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;

import lombok.extern.slf4j.Slf4j;

@Slf4j
class DefaultBlockHoundIntegrationTest {
    @Test
    public void latch() throws Throwable {
        MockCloud mockCloud = MockCloud.newMock();
        ApplicationConfig cfg = mockCloud.build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        cfg.setLocalProperty(props.APP_BLOCKHOUND_ENABLED.getKey(), true);

        SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        MutableBoolean failed = new MutableBoolean(false);
        CountDownLatch executed = new CountDownLatch(1);

        try {
            bootstrap.run();
            bootstrap.platform("system").execute(new Runnable() {
                @Override
                public void run() {
                    CountDownLatch latch = new CountDownLatch(1);
                    DefaultBlockHoundIntegration.FLAG.set(true);

                    try {
                        log.info("about to await in blocking manner ...");
                        latch.await(1, TimeUnit.SECONDS);
                    } catch (InterruptedException err) {
                        Thread.currentThread().interrupt();
                    } catch (Throwable err) {
                        log.atError().setCause(err).log();
                        failed.setTrue();
                    } finally {
                        DefaultBlockHoundIntegration.FLAG.remove();
                        executed.countDown();
                    }
                }
            });

            executed.await();
            Assertions.assertTrue(failed.getValue());
        } finally {
            bootstrap.shutdown();
        }
    }
    @Test
    public void http() throws Throwable {
        MockCloud mockCloud = MockCloud.newMock();
        ApplicationConfig cfg = mockCloud.build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        cfg.setLocalProperty(props.APP_BLOCKHOUND_ENABLED.getKey(), true);

        CloseableHttpClient httpClient = HttpClients.createDefault();
        SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        MutableBoolean failed = new MutableBoolean(false);
        CountDownLatch executed = new CountDownLatch(1);

        try {
            bootstrap.run();
            bootstrap.platform("mock").execute(new Runnable() {
                @Override
                public void run() {
                    DefaultBlockHoundIntegration.FLAG.set(true);

                    try {
                        log.info("about to make blocking http call ...");
                        HttpGet req = new HttpGet("https://google.com?q=DDOS");
                        try (CloseableHttpResponse resp = httpClient.execute(req)) {

                        }
                    } catch (Throwable err) {
                        log.atError().setCause(err).log();
                        failed.setTrue();
                    } finally {
                        DefaultBlockHoundIntegration.FLAG.remove();
                        executed.countDown();
                    }
                }
            });

            executed.await();
            Assertions.assertTrue(failed.getValue());
        } finally {
            httpClient.close();
            bootstrap.shutdown();
        }
    }
}
