package com.turbospaces.executor;

import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor.CallerRunsPolicy;

import lombok.extern.slf4j.Slf4j;
import reactor.blockhound.integration.DefaultBlockHoundIntegration;

@Slf4j
public class LogQueueFullCallerRunsPolicy extends CallerRunsPolicy {
    private final ThreadLocal<Boolean> flag = DefaultBlockHoundIntegration.FLAG;

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        log.error("task: {} will be executed in current thread because {} has no resources to run it", r, e);

        //
        // ~ if should not happen normally, but if this occurs we don't want to bombard sentry 2 times
        //
        boolean toReset = flag.get();
        try {
            flag.set(false);
            super.rejectedExecution(r, e);
        } finally {
            flag.set(toReset);
        }
    }
}
