/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.rpc;

import api.v1.ApiFactory;
import api.v1.Headers;
import api.v1.MockApiFactory;
import api.v1.MockResponseWrapper;
import api.v1.RequestWrapper;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.turbospaces.api.facade.DefaultRequestWrapperFacade;
import com.turbospaces.api.facade.MockResponseWrapperFacade;
import com.turbospaces.api.facade.RequestWrapperFacade;
import com.turbospaces.api.facade.ResponseWrapperFacade;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.dispatch.AbstractSafeResponseConsumer;
import com.turbospaces.rpc.ApiResponse;
import com.turbospaces.rpc.CompletableRequestReplyMapper;
import com.turbospaces.rpc.DefaultApiResponse;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SafeResponseConsumerTest {
    private static final Logger log = LoggerFactory.getLogger(SafeResponseConsumerTest.class);

    SafeResponseConsumerTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void works() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap boot = new SimpleBootstrap(props);
        boot.run(new String[0]);
        try {
            final SettableFuture future = SettableFuture.create();
            final Timestamp req = Timestamp.newBuilder().setSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
            final Headers headers = Headers.newBuilder().setMessageId(PlatformUtil.randomUUID().toString()).build();
            final MockApiFactory apiFactory = new MockApiFactory();
            DefaultRequestWrapperFacade reqw = new DefaultRequestWrapperFacade(apiFactory.eventTemplate(), RequestWrapper.newBuilder().setHeaders(headers).setBody(Any.pack((Message)req)));
            boot.globalPlatform().execute(new Runnable(){

                @Override
                public void run() {
                    future.set((Object)new MockResponseWrapperFacade(apiFactory.eventTemplate(), new MockResponseWrapper(headers, Any.pack((Message)req))));
                }
            });
            DefaultApiResponse apiResponse = new DefaultApiResponse((ListenableFuture)future, (ApiFactory)apiFactory, Timestamp.class, (RequestWrapperFacade)reqw);
            final CountDownLatch latch = new CountDownLatch(1);
            AbstractSafeResponseConsumer consumer = new AbstractSafeResponseConsumer((ApiResponse)apiResponse, (ApiFactory)Mockito.mock(ApiFactory.class)){

                public void accept(ResponseWrapperFacade t) throws Throwable {
                    latch.countDown();
                }
            };
            consumer.run();
            latch.await();
        }
        finally {
            boot.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void exception() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap boot = new SimpleBootstrap(props);
        boot.run(new String[0]);
        try {
            final SettableFuture future = SettableFuture.create();
            final Timestamp req = Timestamp.newBuilder().setSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
            final Headers headers = Headers.newBuilder().setMessageId(PlatformUtil.randomUUID().toString()).build();
            final MockApiFactory apiFactory = new MockApiFactory();
            DefaultRequestWrapperFacade reqw = new DefaultRequestWrapperFacade(apiFactory.eventTemplate(), RequestWrapper.newBuilder().setHeaders(headers).setBody(Any.pack((Message)req)));
            boot.globalPlatform().execute(new Runnable(){

                @Override
                public void run() {
                    future.set((Object)new MockResponseWrapperFacade(apiFactory.eventTemplate(), new MockResponseWrapper(headers, Any.pack((Message)req))));
                }
            });
            DefaultApiResponse apiResponse = new DefaultApiResponse((ListenableFuture)future, (ApiFactory)apiFactory, Timestamp.class, (RequestWrapperFacade)reqw);
            final CountDownLatch latch = new CountDownLatch(1);
            AbstractSafeResponseConsumer consumer = new AbstractSafeResponseConsumer((ApiResponse)apiResponse, (ApiFactory)Mockito.mock(ApiFactory.class)){

                public void onFailure(Throwable t) {
                    super.onFailure(t);
                    latch.countDown();
                }

                public void accept(ResponseWrapperFacade t) throws Throwable {
                    throw new IllegalArgumentException();
                }
            };
            consumer.run();
            latch.await();
        }
        finally {
            boot.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void timeout() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap boot = new SimpleBootstrap(props);
        boot.run(new String[0]);
        try {
            SettableFuture future = SettableFuture.create();
            FluentFuture fluent = FluentFuture.from((ListenableFuture)future).withTimeout(Duration.ofMillis(1L), (ScheduledExecutorService)boot.globalPlatform());
            Timestamp req = Timestamp.newBuilder().setSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
            MockApiFactory apiFactory = new MockApiFactory();
            DefaultRequestWrapperFacade reqw = new DefaultRequestWrapperFacade(apiFactory.eventTemplate(), RequestWrapper.newBuilder().setHeaders(Headers.newBuilder().setMessageId(PlatformUtil.randomUUID().toString())).setBody(Any.pack((Message)req)));
            DefaultApiResponse apiResponse = new DefaultApiResponse((ListenableFuture)fluent, (ApiFactory)apiFactory, Timestamp.class, (RequestWrapperFacade)reqw);
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference code = new AtomicReference();
            AbstractSafeResponseConsumer consumer = new AbstractSafeResponseConsumer((ApiResponse)apiResponse, (ApiFactory)apiFactory){

                public void accept(ResponseWrapperFacade t) throws Throwable {
                    code.set(t.status().isTimeout());
                    log.debug(t.status().errorText());
                    latch.countDown();
                }
            };
            consumer.run();
            latch.await();
            Assertions.assertTrue((boolean)((Boolean)code.get()));
        }
        finally {
            boot.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void timeoutWithMapper() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap boot = new SimpleBootstrap(props);
        boot.run(new String[0]);
        try {
            CompletableRequestReplyMapper mapper = new CompletableRequestReplyMapper();
            mapper.afterPropertiesSet();
            SettableFuture future = mapper.acquire((Object)PlatformUtil.randomUUID().toString(), Duration.ofMillis(1L));
            Timestamp req = Timestamp.newBuilder().setSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
            MockApiFactory apiFactory = new MockApiFactory();
            DefaultRequestWrapperFacade reqw = new DefaultRequestWrapperFacade(apiFactory.eventTemplate(), RequestWrapper.newBuilder().setHeaders(Headers.newBuilder().setMessageId(PlatformUtil.randomUUID().toString())).setBody(Any.pack((Message)req)));
            DefaultApiResponse apiResponse = new DefaultApiResponse((ListenableFuture)future, (ApiFactory)apiFactory, Timestamp.class, (RequestWrapperFacade)reqw);
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference code = new AtomicReference();
            AbstractSafeResponseConsumer consumer = new AbstractSafeResponseConsumer((ApiResponse)apiResponse, (ApiFactory)apiFactory){

                public void accept(ResponseWrapperFacade t) throws Throwable {
                    code.set(t.status().isTimeout());
                    log.debug(t.status().errorText());
                    latch.countDown();
                }
            };
            consumer.run();
            latch.await();
            mapper.destroy();
            Assertions.assertTrue((boolean)((Boolean)code.get()));
        }
        finally {
            boot.shutdown();
        }
    }
}

