package com.turbospaces.executor;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

import reactor.blockhound.integration.DefaultBlockHoundIntegration;

class BlockhoundTolerantScheduledThreadPoolExecutor extends ScheduledThreadPoolExecutor {
    private final ThreadLocal<Boolean> flag = DefaultBlockHoundIntegration.FLAG;

    public BlockhoundTolerantScheduledThreadPoolExecutor(
            int corePoolSize,
            ThreadFactory threadFactory,
            RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }
    @Override
    public boolean prestartCoreThread() {
        boolean toReset = flag.get();
        try {
            flag.set(false);
            return super.prestartCoreThread();
        } finally {
            flag.set(toReset);
        }
    }
}
