/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.netflix.archaius.api.annotations.Configuration;
import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.MockBootstrap;
import com.turbospaces.boot.SchedulingDiModule;
import com.turbospaces.support.TimedConfiguration;
import io.micrometer.core.annotation.Timed;
import jakarta.inject.Inject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.jupiter.api.Assertions;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@Import(value={SchedulingDiModule.class, TimedConfiguration.class})
public class MockConfig
extends AbstractBootstrapAware {
    @Bean
    public HttpFactory factory(HttpClientBuilder client) {
        return new HttpFactory(client);
    }

    @Bean
    public Foo foo(HttpFactory factory) throws Exception {
        return new Foo((CloseableHttpClient)factory.getObject());
    }

    @Scheduled(fixedRate=1000L)
    public void mock() {
        this.logger.info("The time is now {}", (Object)new SimpleDateFormat("HH:mm:ss").format(new Date()));
    }

    @Bean
    public MockBootstrap.InboundChannel inboundChannel() throws Exception {
        URIBuilder uri = new URIBuilder().setScheme("http").setHost("localhost").setPath("/v1/status").setPort(this.bootstrap.port());
        return new MockBootstrap.InboundChannel(uri.build());
    }

    public static class HttpFactory
    extends AbstractFactoryBean<CloseableHttpClient> {
        private final HttpClientBuilder builder;

        public HttpFactory(HttpClientBuilder builder) {
            this.builder = Objects.requireNonNull(builder);
        }

        public Class<?> getObjectType() {
            return CloseableHttpClient.class;
        }

        protected CloseableHttpClient createInstance() throws Exception {
            return this.builder.build();
        }

        protected void destroyInstance(CloseableHttpClient instance) throws Exception {
            instance.close();
        }
    }

    public static class Foo
    extends AbstractBootstrapAware
    implements InitializingBean,
    DisposableBean {
        @Value(value="cloud.application.app-id")
        String appId;
        private final CloseableHttpClient client;

        @Inject
        public Foo(CloseableHttpClient client) {
            this.client = Objects.requireNonNull(client);
        }

        public void afterPropertiesSet() throws Exception {
            this.logger.debug("Starting foo bean now ...");
        }

        public void destroy() throws Exception {
            this.logger.debug("Stopping foo bean now ...");
        }

        @Timed
        public void print() throws InterruptedException {
            final CountDownLatch l = new CountDownLatch(1);
            this.bootstrap.globalPlatform().execute(new Runnable(){

                @Override
                public void run() {
                    logger.debug(this.toString());
                    l.countDown();
                }
            });
            Assertions.assertTrue((boolean)l.await(30L, TimeUnit.SECONDS));
        }

        public String toString() {
            ToStringBuilder toString = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE);
            return toString.append("appId", (Object)this.appId).append("client", (Object)this.client).append("version", (Object)this.bootstrap.release()).build();
        }
    }
}

