/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common;

import com.google.common.collect.Maps;
import com.neovisionaries.i18n.CountryCode;
import com.turbospaces.common.PlatformUtil;
import java.time.Instant;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PlatformUtilTest {
    PlatformUtilTest() {
    }

    @Test
    void iso2() {
        HashMap ISO2_CODES = Maps.newHashMap();
        String[] countries = Locale.getISOCountries();
        for (String country : countries) {
            Locale locale = new Locale("", country);
            ISO2_CODES.put(country, locale.getISO3Country().toUpperCase());
        }
        for (Map.Entry entry : ISO2_CODES.entrySet()) {
            CountryCode country = CountryCode.getByAlpha2Code((String)((String)entry.getKey()));
            Assertions.assertEquals(entry.getValue(), (Object)country.getAlpha3());
        }
    }

    @Test
    void iso3() {
        HashMap ISO3_CODES = Maps.newHashMap();
        String[] countries = Locale.getISOCountries();
        for (String country : countries) {
            Locale locale = new Locale("", country);
            ISO3_CODES.put(locale.getISO3Country().toUpperCase(), locale.getCountry().toUpperCase());
        }
        for (Map.Entry entry : ISO3_CODES.entrySet()) {
            CountryCode country = CountryCode.getByAlpha3Code((String)((String)entry.getKey()));
            Assertions.assertEquals(entry.getValue(), (Object)country.getAlpha2());
        }
    }

    @Test
    public void parseMillis() {
        long now = System.currentTimeMillis();
        Instant dateTime = PlatformUtil.parseTimestamp((String)Long.toString(now));
        Assertions.assertEquals((long)now, (long)dateTime.toEpochMilli());
    }

    @Test
    public void parseUnitTime() {
        long now = System.currentTimeMillis() / 1000L;
        Instant dateTime = PlatformUtil.parseTimestamp((String)Long.toString(now));
        Assertions.assertEquals((long)(now * 1000L), (long)dateTime.toEpochMilli());
    }
}

