/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.turbospaces.api.facade.ResponseWrapperFacade;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.rpc.CompletableRequestReplyMapper;
import com.turbospaces.rpc.DefaultRequestReplyMapper;
import com.turbospaces.rpc.RequestReplyTimeout;
import io.micrometer.core.instrument.search.RequiredSearch;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CompletableRequestReplyMapperTest {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    CompletableRequestReplyMapper<UUID, ResponseWrapperFacade> mapper;

    @AfterEach
    public void after() throws Exception {
        this.mapper.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void works() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        SimpleBootstrap bootstrap = new SimpleBootstrap(new ApplicationProperties(cfg));
        bootstrap.run(new String[0]);
        try {
            this.mapper = new DefaultRequestReplyMapper();
            this.mapper.setBootstrap((Bootstrap)bootstrap);
            this.mapper.afterPropertiesSet();
            UUID key = UUID.randomUUID();
            final CountDownLatch l = new CountDownLatch(1);
            SettableFuture f = this.mapper.acquire((Object)key, Duration.ofSeconds(15L));
            f.addListener(new Runnable(){

                @Override
                public void run() {
                    l.countDown();
                }
            }, MoreExecutors.directExecutor());
            Assertions.assertEquals((int)1, (int)this.mapper.pendingCount());
            MDC.put((String)"operation", (String)"test");
            this.mapper.complete((Object)key, (Object)((ResponseWrapperFacade)Mockito.mock(ResponseWrapperFacade.class)));
            Assertions.assertTrue((boolean)l.await(30L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)0, (int)this.mapper.pendingCount());
            RequiredSearch search1 = bootstrap.meterRegistry().get("reply.complete.latency").tag("operation", "test");
            Assertions.assertNotNull((Object)search1.timer());
        }
        finally {
            bootstrap.shutdown();
        }
    }

    @Test
    public void timeoutRaw() throws InterruptedException {
        this.mapper = new CompletableRequestReplyMapper();
        this.mapper.afterPropertiesSet();
        UUID key = UUID.randomUUID();
        CountDownLatch l = new CountDownLatch(1);
        SettableFuture f = this.mapper.acquire((Object)key, Duration.ofMillis(1L));
        f.addListener(new Runnable(){
            final /* synthetic */ ListenableFuture val$f;
            final /* synthetic */ CountDownLatch val$l;
            {
                this.val$f = listenableFuture;
                this.val$l = countDownLatch;
            }

            @Override
            public void run() {
                try {
                    this.val$f.get();
                }
                catch (Exception err) {
                    RequestReplyTimeout timeout = (RequestReplyTimeout)err.getCause();
                    CompletableRequestReplyMapperTest.this.logger.error(timeout.getMessage(), (Throwable)timeout);
                    this.val$l.countDown();
                }
            }
        }, MoreExecutors.directExecutor());
        Assertions.assertTrue((boolean)l.await(30L, TimeUnit.SECONDS));
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(1L)).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CompletableRequestReplyMapperTest.this.mapper.pendingCount() == 0;
            }
        });
    }

    @Test
    public void timeoutFluent() throws InterruptedException {
        this.mapper = new CompletableRequestReplyMapper();
        this.mapper.afterPropertiesSet();
        UUID key = UUID.randomUUID();
        final CountDownLatch l = new CountDownLatch(1);
        FluentFuture f = FluentFuture.from((ListenableFuture)this.mapper.acquire((Object)key, Duration.ofMillis(1L)));
        f.addCallback((FutureCallback)new FutureCallback<ResponseWrapperFacade>(){

            public void onSuccess(ResponseWrapperFacade result) {
            }

            public void onFailure(Throwable t) {
                RequestReplyTimeout timeout = (RequestReplyTimeout)ExceptionUtils.getRootCause((Throwable)t);
                CompletableRequestReplyMapperTest.this.logger.error(timeout.getMessage(), (Throwable)timeout);
                l.countDown();
            }
        }, this.mapper);
        Assertions.assertTrue((boolean)l.await(30L, TimeUnit.SECONDS));
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(1L)).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CompletableRequestReplyMapperTest.this.mapper.pendingCount() == 0;
            }
        });
    }

    @Test
    public void exceptionally() throws InterruptedException {
        this.mapper = new CompletableRequestReplyMapper();
        this.mapper.afterPropertiesSet();
        UUID key = UUID.randomUUID();
        final CountDownLatch l = new CountDownLatch(1);
        FluentFuture f = FluentFuture.from((ListenableFuture)this.mapper.acquire((Object)key, Duration.ofMinutes(1L)));
        f.addCallback((FutureCallback)new FutureCallback<ResponseWrapperFacade>(){

            public void onSuccess(ResponseWrapperFacade result) {
            }

            public void onFailure(Throwable t) {
                l.countDown();
            }
        }, this.mapper);
        this.mapper.completeExceptionally((Object)key, (Throwable)new IllegalStateException());
        Assertions.assertTrue((boolean)l.await(30L, TimeUnit.SECONDS));
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(1L)).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CompletableRequestReplyMapperTest.this.mapper.pendingCount() == 0;
            }
        });
    }
}

