/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.turbospaces.boot.CustomRetryRegistry;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.RetryAspectTest;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import io.github.resilience4j.core.IntervalBiFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CustomRetryRegistryTest {
    @Test
    void testRetryDefaultConfig() throws Throwable {
        MockCloud mockCloud = MockCloud.newMock();
        ApplicationConfig cfg = mockCloud.build();
        SimpleBootstrap bootstrap = new SimpleBootstrap(new ApplicationProperties(cfg), new Class[]{RetryAspectTest.AppConfig.class});
        ApplicationProperties props = bootstrap.props();
        CustomRetryRegistry retryRegistry = new CustomRetryRegistry(props);
        Retry retryWithDefaultConfig = retryRegistry.retry("retry-without-special-config");
        Integer maxAttempts = (Integer)props.APP_BACKOFF_RETRY_NUM.get();
        Duration initialDelay = (Duration)props.APP_BACKOFF_RETRY_FIRST.get();
        Duration maxDelay = (Duration)props.APP_BACKOFF_RETRY_MAX.get();
        RetryConfig config = retryWithDefaultConfig.getRetryConfig();
        IntervalBiFunction intervalBiFunction = config.getIntervalBiFunction();
        Assertions.assertEquals((Integer)maxAttempts, (int)config.getMaxAttempts());
        CustomRetryRegistryTest.checkIntervalFunction(config.getMaxAttempts(), (IntervalBiFunction<Object>)intervalBiFunction, initialDelay.toMillis(), maxDelay.toMillis());
    }

    @Test
    void testRetryDynamicConfig() throws Throwable {
        MockCloud mockCloud = MockCloud.newMock();
        ApplicationConfig cfg = mockCloud.build();
        SimpleBootstrap bootstrap = new SimpleBootstrap(new ApplicationProperties(cfg), new Class[]{RetryAspectTest.AppConfig.class});
        String testRetryName = "test-retry";
        Duration initialDelay = Duration.ofMillis(2L);
        Duration maxDelay = Duration.ofMillis(3L);
        int maxAttempts = 3;
        ApplicationProperties props = bootstrap.props();
        bootstrap.cfg().setLocalProperty(testRetryName + "." + props.APP_BACKOFF_RETRY_FIRST.getKey(), (Object)initialDelay);
        bootstrap.cfg().setLocalProperty(testRetryName + "." + props.APP_BACKOFF_RETRY_MAX.getKey(), (Object)maxDelay);
        bootstrap.cfg().setLocalProperty(testRetryName + "." + props.APP_BACKOFF_RETRY_NUM.getKey(), (Object)maxAttempts);
        CustomRetryRegistry retryRegistry = new CustomRetryRegistry(props);
        Retry retryWithDefaultConfig = retryRegistry.retry(testRetryName);
        RetryConfig config = retryWithDefaultConfig.getRetryConfig();
        IntervalBiFunction intervalBiFunction = config.getIntervalBiFunction();
        Assertions.assertEquals((int)maxAttempts, (int)config.getMaxAttempts());
        CustomRetryRegistryTest.checkIntervalFunction(config.getMaxAttempts(), (IntervalBiFunction<Object>)intervalBiFunction, initialDelay.toMillis(), maxDelay.toMillis());
    }

    @Test
    void testDynamicRetryWithInitialDelayOverridden() throws Throwable {
        MockCloud mockCloud = MockCloud.newMock();
        ApplicationConfig cfg = mockCloud.build();
        SimpleBootstrap bootstrap = new SimpleBootstrap(new ApplicationProperties(cfg), new Class[]{RetryAspectTest.AppConfig.class});
        ApplicationProperties props = bootstrap.props();
        String testRetryName = "test-retry-with-custom-initial-delay";
        Duration initialDelay = Duration.ofMillis(100L);
        Duration maxDelay = (Duration)props.APP_BACKOFF_RETRY_MAX.get();
        Integer maxAttempts = (Integer)props.APP_BACKOFF_RETRY_NUM.get();
        bootstrap.cfg().setLocalProperty(testRetryName + "." + props.APP_BACKOFF_RETRY_FIRST.getKey(), (Object)initialDelay);
        CustomRetryRegistry retryRegistry = new CustomRetryRegistry(props);
        Retry retryWithDefaultConfig = retryRegistry.retry(testRetryName);
        RetryConfig config = retryWithDefaultConfig.getRetryConfig();
        IntervalBiFunction intervalBiFunction = config.getIntervalBiFunction();
        Assertions.assertEquals((Integer)maxAttempts, (int)config.getMaxAttempts());
        CustomRetryRegistryTest.checkIntervalFunction(config.getMaxAttempts(), (IntervalBiFunction<Object>)intervalBiFunction, initialDelay.toMillis(), maxDelay.toMillis());
    }

    private static void checkIntervalFunction(int maxAttempts, IntervalBiFunction<Object> intervalBiFunction, long expectedInitialDelay, long maxDelay) {
        long expectedValue = expectedInitialDelay;
        int i = 1;
        do {
            Assertions.assertEquals((long)expectedValue, (Long)((Long)intervalBiFunction.apply((Object)i, null)));
            expectedValue = (long)((double)expectedValue * 1.5);
            expectedValue = Math.min(expectedValue, maxDelay);
        } while (++i <= maxAttempts);
    }
}

