package com.turbospaces.boot;

import java.util.concurrent.Executor;

import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@Async
@EnableScheduling
public class SchedulingDiModule extends AbstractBootstrapAware implements SchedulingConfigurer, AsyncConfigurer {
    @Override
    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setTaskScheduler(new ConcurrentTaskScheduler(bootstrap.globalPlatform()));
    }
    @Override
    public Executor getAsyncExecutor() {
        return bootstrap.globalPlatform();
    }
}
