package reactor.blockhound.integration;

import java.util.function.Function;
import java.util.function.Predicate;

import com.turbospaces.executor.GlobalPlatformThread;
import com.turbospaces.executor.PlatformThread;

import reactor.blockhound.BlockHound;

public class DefaultBlockHoundIntegration implements BlockHoundIntegration {
    public static final ThreadLocal<Boolean> FLAG = new ThreadLocal<>() {
        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    @Override
    public void applyTo(BlockHound.Builder builder) {
        builder.dynamicThreadPredicate(new Function<Predicate<Thread>, Predicate<Thread>>() {
            @Override
            public Predicate<Thread> apply(Predicate<Thread> prediction) {
                return prediction.or(new Predicate<Thread>() {
                    @Override
                    public boolean test(Thread t) {
                        return Boolean.TRUE.equals(FLAG.get());
                    }
                });
            }
        });
        builder.nonBlockingThreadPredicate(new Function<Predicate<Thread>, Predicate<Thread>>() {
            @Override
            public Predicate<Thread> apply(Predicate<Thread> root) {
                return root.or(new Predicate<Thread>() {
                    @Override
                    public boolean test(Thread t) {
                        if (t instanceof GlobalPlatformThread) {

                        } else if (t instanceof PlatformThread) {

                        }

                        return false;
                    }
                });
            }
        });
    }
}
