/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.cfg;

import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.DynamicPropertyFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DynamicPropertyFactoryTest {
    private static final String PROPERTY_NAME = "soft-kyc-required-before-purchase.percentage.users-applied";
    private static final int DEFAULT_VALUE = 1;
    private static final String WRONG_VALUE = "50akDFs83$#%#";
    private static final int CORRECT_VALUE = 50;

    @Test
    public void testOrElseGetCorrectValue() throws ConfigException {
        DynamicPropertyFactory factory = DynamicPropertyFactoryTest.createDynamicPropertyFactory(PROPERTY_NAME, 50);
        Property integerProperty = factory.get(PROPERTY_NAME, Integer.class);
        Integer integerValue = (Integer)integerProperty.orElse((Object)1).get();
        Assertions.assertEquals((int)50, (Integer)integerValue);
    }

    @Test
    public void testOrElseGetWrongValueDefault() throws ConfigException {
        DynamicPropertyFactory factory = DynamicPropertyFactoryTest.createDynamicPropertyFactory(PROPERTY_NAME, WRONG_VALUE);
        Property integerProperty = factory.get(PROPERTY_NAME, Integer.class);
        Integer integerValue = (Integer)integerProperty.orElse((Object)1).get();
        Assertions.assertEquals((int)1, (Integer)integerValue);
    }

    @Test
    public void testOrElseGetNullValueDefault() throws ConfigException {
        DynamicPropertyFactory factory = DynamicPropertyFactoryTest.createDynamicPropertyFactory(PROPERTY_NAME, null);
        Property integerProperty = factory.get(PROPERTY_NAME, Integer.class);
        Integer integerValue = (Integer)integerProperty.orElse((Object)1).get();
        Assertions.assertEquals((int)1, (Integer)integerValue);
    }

    @Test
    public void testOrElseGetEmptyValueDefault() throws ConfigException {
        DynamicPropertyFactory factory = DynamicPropertyFactoryTest.createDynamicPropertyFactory(PROPERTY_NAME, "");
        Property integerProperty = factory.get(PROPERTY_NAME, Integer.class);
        Integer integerValue = (Integer)integerProperty.orElse((Object)1).get();
        Assertions.assertEquals((int)1, (Integer)integerValue);
    }

    @Test
    public void testGetCorrectValue() throws ConfigException {
        DynamicPropertyFactory factory = DynamicPropertyFactoryTest.createDynamicPropertyFactory(PROPERTY_NAME, 50);
        Property integerProperty = factory.get(PROPERTY_NAME, Integer.class);
        Integer integerValue = (Integer)integerProperty.orElse((Object)1).get();
        Assertions.assertEquals((int)50, (Integer)integerValue);
    }

    @Test
    public void testWrongValueDefault() throws ConfigException {
        DynamicPropertyFactory factory = DynamicPropertyFactoryTest.createDynamicPropertyFactory(PROPERTY_NAME, WRONG_VALUE);
        Property integerProperty = factory.get(PROPERTY_NAME, Integer.class);
        Integer integerValue = (Integer)integerProperty.orElse((Object)1).get();
        Assertions.assertEquals((int)1, (Integer)integerValue);
    }

    @Test
    public void testGetNullValueNull() throws ConfigException {
        DynamicPropertyFactory factory = DynamicPropertyFactoryTest.createDynamicPropertyFactory(PROPERTY_NAME, null);
        Property integerProperty = factory.get(PROPERTY_NAME, Integer.class);
        Integer integerValue = (Integer)integerProperty.get();
        Assertions.assertNull((Object)integerValue);
    }

    @Test
    public void testGetEmptyValueNull() throws ConfigException {
        DynamicPropertyFactory factory = DynamicPropertyFactoryTest.createDynamicPropertyFactory(PROPERTY_NAME, "");
        Property integerProperty = factory.get(PROPERTY_NAME, Integer.class);
        Integer integerValue = (Integer)integerProperty.get();
        Assertions.assertNull((Object)integerValue);
    }

    private static DynamicPropertyFactory createDynamicPropertyFactory(String name, String value) throws ConfigException {
        ApplicationConfig config = ApplicationConfig.create();
        config.setLocalProperty(name, (Object)value);
        return DynamicPropertyFactory.from((Config)config);
    }

    private static DynamicPropertyFactory createDynamicPropertyFactory(String name, int value) throws ConfigException {
        ApplicationConfig config = ApplicationConfig.create();
        config.setLocalProperty(name, (Object)String.valueOf(value));
        return DynamicPropertyFactory.from((Config)config);
    }
}

