/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import com.google.common.math.DoubleMath;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.search.MeterNotFoundException;
import io.sentry.SentryClient;
import io.sentry.event.EventBuilder;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.util.ReflectionTestUtils;

public class SentryAppenderContextTest {
    private final double doubleTolerance = 0.5;

    @Test
    void baseScenarioCheckRateLimiterAndMetrics_success() throws Throwable {
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("app.dev.mode", false);
        propMap.put("logback.rate.limiter.sentry.appender.enabled", true);
        propMap.put("logback.rate.limiter.sentry.appender.metrics.enabled", true);
        ApplicationProperties applicationProperties = SentryAppenderContextTest.getApplicationProperties(propMap);
        Logger logger = LoggerFactory.getLogger(this.getClass());
        SimpleBootstrap bootstrap = new SimpleBootstrap(applicationProperties);
        SentryClient sentryClientMock = SentryAppenderContextTest.mockSentryClient();
        Integer logbackRateLimiterSentryAppenderCount = (Integer)applicationProperties.LOGBACK_RATE_LIMITER_SENTRY_APPENDER_COUNT.get();
        int amountOfErrors = logbackRateLimiterSentryAppenderCount * 3;
        String errorMessage = "n errors call: {}";
        for (int i = 0; i < amountOfErrors; ++i) {
            logger.error(errorMessage, (Object)i);
        }
        CompositeMeterRegistry meterRegistry = SentryAppenderContextTest.getCompositeMeterRegistry();
        Awaitility.await().atMost(5000L, TimeUnit.MILLISECONDS).pollDelay(500L, TimeUnit.MILLISECONDS).until(() -> {
            Double actual = meterRegistry.get("logback.sentry-appender.skipped-events.counter").counter().count();
            Double expected = amountOfErrors - logbackRateLimiterSentryAppenderCount;
            return DoubleMath.fuzzyEquals((double)actual, (double)expected, (double)0.5);
        });
        Assertions.assertTrue((meterRegistry == bootstrap.meterRegistry() ? 1 : 0) != 0);
        double amountOfSkippedErrors = meterRegistry.get("logback.sentry-appender.skipped-events.counter").counter().count();
        Assertions.assertTrue((boolean)DoubleMath.fuzzyEquals((double)(amountOfErrors - logbackRateLimiterSentryAppenderCount), (double)amountOfSkippedErrors, (double)0.5));
        RateLimiterRegistry rateLimiterRegistry = SentryAppenderContextTest.getRateLimiterRegistry();
        Assertions.assertNotEquals((Object)bootstrap.rateLimiterRegistry(), (Object)rateLimiterRegistry);
        String rateLimiterKey = "rate-limiter-sentry-appender." + this.getClass().getName();
        boolean containsRateLimiter = rateLimiterRegistry.getAllRateLimiters().stream().anyMatch(rlim -> rlim.getName().equals(rateLimiterKey));
        Assertions.assertTrue((boolean)containsRateLimiter, (String)("RateLimiter does not contains limiter from SentryAppender: " + rateLimiterKey));
        Optional currentRateLimiterConfig = rateLimiterRegistry.getConfiguration(rateLimiterKey);
        boolean limitExceeded = !rateLimiterRegistry.rateLimiter(rateLimiterKey, String.valueOf(currentRateLimiterConfig)).acquirePermission();
        Assertions.assertTrue((boolean)limitExceeded, (String)("Failed checked rate limitExceeded with period:  " + applicationProperties.LOGBACK_RATE_LIMITER_SENTRY_APPENDER_PERIOD.get()));
        ((SentryClient)Mockito.verify((Object)sentryClientMock, (VerificationMode)Mockito.times((int)logbackRateLimiterSentryAppenderCount))).sendEvent((EventBuilder)ArgumentMatchers.any(EventBuilder.class));
    }

    @Test
    void baseScenarioCheckRateLimiterAndMetricsWithExceptionInLogger_success() throws Throwable {
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("app.dev.mode", false);
        propMap.put("logback.rate.limiter.sentry.appender.enabled", true);
        propMap.put("logback.rate.limiter.sentry.appender.metrics.enabled", true);
        ApplicationProperties applicationProperties = SentryAppenderContextTest.getApplicationProperties(propMap);
        Logger logger = LoggerFactory.getLogger(this.getClass());
        SimpleBootstrap bootstrap = new SimpleBootstrap(applicationProperties);
        SentryClient sentryClientMock = SentryAppenderContextTest.mockSentryClient();
        Integer logbackRateLimiterSentryAppenderCount = (Integer)applicationProperties.LOGBACK_RATE_LIMITER_SENTRY_APPENDER_COUNT.get();
        int amountOfErrors = logbackRateLimiterSentryAppenderCount * 3;
        String errorMessage = "n errors call: {}";
        for (int i = 0; i < amountOfErrors; ++i) {
            logger.error(errorMessage, (Throwable)new IllegalAccessException());
        }
        CompositeMeterRegistry meterRegistry = SentryAppenderContextTest.getCompositeMeterRegistry();
        Awaitility.await().atMost(5000L, TimeUnit.MILLISECONDS).pollDelay(500L, TimeUnit.MILLISECONDS).until(() -> {
            Double actual = meterRegistry.get("logback.sentry-appender.skipped-events.counter").counter().count();
            Double expected = amountOfErrors - logbackRateLimiterSentryAppenderCount;
            return DoubleMath.fuzzyEquals((double)actual, (double)expected, (double)0.5);
        });
        Assertions.assertTrue((meterRegistry == bootstrap.meterRegistry() ? 1 : 0) != 0);
        double amountOfSkippedErrors = meterRegistry.get("logback.sentry-appender.skipped-events.counter").counter().count();
        Assertions.assertTrue((boolean)DoubleMath.fuzzyEquals((double)(amountOfErrors - logbackRateLimiterSentryAppenderCount), (double)amountOfSkippedErrors, (double)0.5));
        RateLimiterRegistry rateLimiterRegistry = SentryAppenderContextTest.getRateLimiterRegistry();
        Assertions.assertNotEquals((Object)bootstrap.rateLimiterRegistry(), (Object)rateLimiterRegistry);
        String rateLimiterKey = "rate-limiter-sentry-appender." + this.getClass().getName() + "_IllegalAccessException";
        boolean containsRateLimiter = rateLimiterRegistry.getAllRateLimiters().stream().anyMatch(rlim -> rlim.getName().equals(rateLimiterKey));
        Assertions.assertTrue((boolean)containsRateLimiter, (String)("RateLimiter does not contains limiter from SentryAppender: " + rateLimiterKey));
        Optional currentRateLimiterConfig = rateLimiterRegistry.getConfiguration(rateLimiterKey);
        boolean limitExceeded = !rateLimiterRegistry.rateLimiter(rateLimiterKey, String.valueOf(currentRateLimiterConfig)).acquirePermission();
        Assertions.assertTrue((boolean)limitExceeded, (String)("Failed checked rate limitExceeded with period:  " + applicationProperties.LOGBACK_RATE_LIMITER_SENTRY_APPENDER_PERIOD.get()));
        ((SentryClient)Mockito.verify((Object)sentryClientMock, (VerificationMode)Mockito.times((int)logbackRateLimiterSentryAppenderCount))).sendEvent((EventBuilder)ArgumentMatchers.any(EventBuilder.class));
    }

    @Test
    void scenarioCheckRateLimiterAndMetricsWithRepeatedSendToSentry() throws Throwable {
        long periodInMilliseconds = 500L;
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("app.dev.mode", false);
        propMap.put("logback.rate.limiter.sentry.appender.period", Duration.ofMillis(periodInMilliseconds));
        propMap.put("logback.rate.limiter.sentry.appender.count", 10);
        propMap.put("logback.rate.limiter.sentry.appender.enabled", true);
        propMap.put("logback.rate.limiter.sentry.appender.metrics.enabled", true);
        ApplicationProperties applicationProperties = SentryAppenderContextTest.getApplicationProperties(propMap);
        Logger logger = LoggerFactory.getLogger(this.getClass());
        SimpleBootstrap bootstrap = new SimpleBootstrap(applicationProperties);
        SentryClient sentryClientMock = SentryAppenderContextTest.mockSentryClient();
        Integer logbackRateLimiterSentryAppenderCount = (Integer)applicationProperties.LOGBACK_RATE_LIMITER_SENTRY_APPENDER_COUNT.get();
        int amountOfErrors = logbackRateLimiterSentryAppenderCount * 3;
        String errorMessage = "n errors call: {}";
        for (int i = 0; i < amountOfErrors; ++i) {
            logger.error(errorMessage, (Object)i);
        }
        CompositeMeterRegistry meterRegistry = SentryAppenderContextTest.getCompositeMeterRegistry();
        Awaitility.await().atMost(5000L, TimeUnit.MILLISECONDS).pollDelay(500L, TimeUnit.MILLISECONDS).until(() -> {
            Double actual = meterRegistry.get("logback.sentry-appender.skipped-events.counter").counter().count();
            Double expected = amountOfErrors - logbackRateLimiterSentryAppenderCount;
            return DoubleMath.fuzzyEquals((double)actual, (double)expected, (double)0.5);
        });
        for (int i = 0; i < amountOfErrors; ++i) {
            logger.error(errorMessage, (Object)i);
        }
        Awaitility.await().atMost(5000L, TimeUnit.MILLISECONDS).pollDelay(500L, TimeUnit.MILLISECONDS).until(() -> {
            Double actual = meterRegistry.get("logback.sentry-appender.skipped-events.counter").counter().count();
            Double expected = 2.0 * Double.valueOf(amountOfErrors - logbackRateLimiterSentryAppenderCount);
            return DoubleMath.fuzzyEquals((double)actual, (double)expected, (double)0.5);
        });
        double amountOfSkippedErrors = meterRegistry.get("logback.sentry-appender.skipped-events.counter").counter().count();
        Assertions.assertTrue((boolean)DoubleMath.fuzzyEquals((double)amountOfSkippedErrors, (double)(2 * (amountOfErrors - logbackRateLimiterSentryAppenderCount)), (double)0.5));
        RateLimiterRegistry rateLimiterRegistry = SentryAppenderContextTest.getRateLimiterRegistry();
        String rateLimiterKey = "rate-limiter-sentry-appender." + this.getClass().getName();
        boolean containsRateLimiter = rateLimiterRegistry.getAllRateLimiters().stream().anyMatch(rlim -> rlim.getName().equals(rateLimiterKey));
        Assertions.assertTrue((boolean)containsRateLimiter, (String)("RateLimiter don't contains limiter from SentryAppender: " + rateLimiterKey));
        ((SentryClient)Mockito.verify((Object)sentryClientMock, (VerificationMode)Mockito.times((int)(2 * logbackRateLimiterSentryAppenderCount)))).sendEvent((EventBuilder)ArgumentMatchers.any(EventBuilder.class));
        bootstrap.shutdown();
    }

    @Test
    void scenarioWithDisabledRateLimiter() throws Throwable {
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("app.dev.mode", false);
        ApplicationProperties applicationProperties = SentryAppenderContextTest.getApplicationProperties(propMap);
        Logger logger = LoggerFactory.getLogger(this.getClass());
        SimpleBootstrap bootstrap = new SimpleBootstrap(applicationProperties);
        SentryClient sentryClientMock = SentryAppenderContextTest.mockSentryClient();
        Integer logbackRateLimiterSentryAppenderCount = (Integer)applicationProperties.LOGBACK_RATE_LIMITER_SENTRY_APPENDER_COUNT.get();
        int amountOfErrors = logbackRateLimiterSentryAppenderCount * 3;
        String errorMessage = "n errors call: {}";
        for (int i = 0; i < amountOfErrors; ++i) {
            logger.error(errorMessage, (Object)i);
        }
        Thread.sleep(500L);
        CompositeMeterRegistry meterRegistry = SentryAppenderContextTest.getCompositeMeterRegistry();
        Assertions.assertThrows(MeterNotFoundException.class, () -> meterRegistry.get("logback.sentry-appender.skipped-events.counter").counter());
        RateLimiterRegistry rateLimiterRegistry = SentryAppenderContextTest.getRateLimiterRegistry();
        String rateLimiterKey = "rate-limiter-sentry-appender." + this.getClass().getName();
        boolean containsRateLimiter = rateLimiterRegistry.getAllRateLimiters().stream().anyMatch(rlim -> rlim.getName().equals(rateLimiterKey));
        Assertions.assertFalse((boolean)containsRateLimiter, (String)("RateLimiter contains limiter from SentryAppender: " + rateLimiterKey));
        ((SentryClient)Mockito.verify((Object)sentryClientMock, (VerificationMode)Mockito.times((int)amountOfErrors))).sendEvent((EventBuilder)ArgumentMatchers.any(EventBuilder.class));
        bootstrap.shutdown();
    }

    private static ApplicationProperties getApplicationProperties(Map<String, Object> setDefaultProp) throws Exception {
        ApplicationConfig cfg = MockCloud.newMock().build();
        cfg.loadLocalDevProperties();
        setDefaultProp.entrySet().forEach(prop -> cfg.setDefaultProperty((String)prop.getKey(), prop.getValue()));
        return new ApplicationProperties(cfg);
    }

    private static CompositeMeterRegistry getCompositeMeterRegistry() {
        return (CompositeMeterRegistry)((LoggerContext)LoggerFactory.getILoggerFactory()).getObject("metrics-registry");
    }

    private static RateLimiterRegistry getRateLimiterRegistry() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Appender sentryAppender = null;
        for (ch.qos.logback.classic.Logger log : loggerContext.getLoggerList()) {
            Appender appender = log.getAppender("SENTRY");
            if (appender == null) continue;
            sentryAppender = appender;
            break;
        }
        return (RateLimiterRegistry)ReflectionTestUtils.getField(sentryAppender, (String)"rateLimiterRegistry");
    }

    private static SentryClient mockSentryClient() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Appender sentryAppender = null;
        for (ch.qos.logback.classic.Logger log : loggerContext.getLoggerList()) {
            Appender appender = log.getAppender("SENTRY");
            if (appender == null) continue;
            sentryAppender = appender;
            break;
        }
        SentryClient sentryClientMock = (SentryClient)Mockito.mock(SentryClient.class);
        ReflectionTestUtils.setField(sentryAppender, (String)"sentry", (Object)sentryClientMock);
        ((SentryClient)Mockito.doNothing().when((Object)sentryClientMock)).sendEvent((EventBuilder)ArgumentMatchers.any(EventBuilder.class));
        return sentryClientMock;
    }
}

