package com.turbospaces.cfg;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

import com.netflix.archaius.AbstractProperty;
import com.netflix.archaius.api.Property;

public class ScopedProperty<T> extends AbstractProperty<T> {
    private final Map<String, Property<T>> properties = new ConcurrentHashMap<>();
    private final Function<String, Property<T>> fetcher;

    public ScopedProperty(String key, Function<String, Property<T>> fetcher) {
        super(key);

        this.fetcher = fetcher;
    }

    @Override
    public T get() {
        return getProperty(getKey()).get();
    }

    public T get(String scope) {
        var scoped = getProperty(scope + "." + getKey()).get();

        return isNullOrEmpty(scoped) ? get() : scoped;
    }

    private Property<T> getProperty(String key) {
        return properties.computeIfAbsent(key, fetcher);
    }

    private boolean isNullOrEmpty(T value) {
        if (value instanceof Collection<?> c) {
            return c.isEmpty();
        } else if (value instanceof Map<?, ?> m) {
            return m.isEmpty();
        }

        return Objects.isNull(value);
    }
}
