package com.turbospaces.common;

import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;

import org.slf4j.MDC;

import com.google.common.collect.ImmutableMap;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class MDCUtil {
    public static ImmutableMap<String, String> propagete(Map<String, String> mdc) {
        if (Objects.nonNull(mdc)) {
            ImmutableMap.Builder<String, String> toReturn = ImmutableMap.builder();

            for (Entry<String, String> entry : mdc.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();

                String current = MDC.get(key);
                if (Objects.isNull(current)) {
                    MDC.put(key, value);
                    toReturn.put(key, value);
                } else {
                    //
                    // ~ corner case (if-not-modified)
                    //
                    if (Objects.equals(current, value)) {
                        MDC.put(key, value);
                        toReturn.put(key, value);
                    }
                }
            }

            return toReturn.build();
        }

        return ImmutableMap.of();
    }
    public static void cleanUp(ImmutableMap<String, String> map) {
        if (Objects.nonNull(map)) {
            for (Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                String current = MDC.get(key);
                if (Objects.nonNull(current)) {
                    //
                    // ~ corner case (if-not-modified)
                    //
                    if (Objects.equals(current, value)) {
                        MDC.remove(key);
                    }
                } else {
                    MDC.remove(key);
                }
            }
        }
    }
}
