/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.turbospaces.ups.UPSs;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudConnector;
import org.springframework.cloud.SmartCloud;
import org.springframework.cloud.SmartCloudConnector;
import org.springframework.cloud.service.ServiceConnectorCreator;
import org.springframework.cloud.service.ServiceInfo;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public class DynamicCloud
extends Cloud
implements SmartCloud,
UPSs,
Disposable {
    private final Sinks.Many<Map<String, ServiceInfo>> upss = Sinks.many().replay().latestOrDefault((Object)Maps.newConcurrentMap());
    private final SmartCloudConnector cloudConnector;

    public DynamicCloud(SmartCloudConnector cloudConnector, List<ServiceConnectorCreator<?, ? extends ServiceInfo>> serviceConnectorCreators) {
        super((CloudConnector)cloudConnector, serviceConnectorCreators);
        this.cloudConnector = cloudConnector;
    }

    public List<ServiceInfo> getServiceInfos() {
        Map map = (Map)this.upss.asFlux().blockFirst();
        if (map.isEmpty()) {
            return super.getServiceInfos();
        }
        ImmutableList.Builder l = ImmutableList.builder();
        l.addAll((Iterable)super.getServiceInfos());
        l.addAll(map.values());
        return l.build();
    }

    public ServiceInfo getServiceInfo(String serviceId) {
        ServiceInfo si = (ServiceInfo)((Map)this.upss.asFlux().blockFirst()).get(serviceId);
        return Objects.nonNull(si) ? si : super.getServiceInfo(serviceId);
    }

    public <T extends ServiceInfo> List<T> getServiceInfosByType(Class<T> serviceInfoType) {
        ImmutableList.Builder l = ImmutableList.builder();
        l.addAll((Iterable)super.getServiceInfosByType(serviceInfoType));
        for (ServiceInfo serviceInfo : ((Map)this.upss.asFlux().blockFirst()).values()) {
            if (!serviceInfoType.isAssignableFrom(serviceInfo.getClass())) continue;
            l.add((Object)serviceInfo);
        }
        return l.build();
    }

    @Override
    public void addUps(ServiceInfo info) {
        List l = super.getServiceInfos();
        for (ServiceInfo si : l) {
            if (!si.getId().equals(info.getId())) continue;
            throw new IllegalArgumentException(String.format("ups: %s already exists and defined in cloud connector", info.getId()));
        }
        Map curr = (Map)this.upss.asFlux().blockFirst();
        curr.put(info.getId(), info);
        Sinks.EmitResult emitResult = this.upss.tryEmitNext((Object)curr);
        Preconditions.checkArgument((boolean)emitResult.isSuccess());
    }

    @Override
    public boolean removeUps(String id) {
        Map curr = (Map)this.upss.asFlux().blockFirst();
        boolean toReturn = Objects.nonNull(curr.remove(id));
        Sinks.EmitResult emitResult = this.upss.tryEmitNext((Object)curr);
        Preconditions.checkArgument((boolean)emitResult.isSuccess());
        return toReturn;
    }

    @Override
    public <T extends ServiceInfo> Flux<ServiceInfo> serviceInfoByName(final String ups) {
        return this.cloudConnector.asFlux().mergeWith((Publisher)this.upss.asFlux()).filter((Predicate)new Predicate<Map<String, ServiceInfo>>(){

            @Override
            public boolean test(Map<String, ServiceInfo> map) {
                return map.containsKey(ups);
            }
        }).map((Function)new Function<Map<String, ServiceInfo>, ServiceInfo>(){

            @Override
            public ServiceInfo apply(Map<String, ServiceInfo> t) {
                return t.get(ups);
            }
        }).distinctUntilChanged(Function.identity(), UPSs::isEquals);
    }

    @Override
    public <T extends ServiceInfo> Flux<ServiceInfo> scopedServiceInfoByName(String scope, final String name) {
        final String scoped = String.format("%s-%s", scope, name);
        return this.cloudConnector.asFlux().mergeWith((Publisher)this.upss.asFlux()).filter((Predicate)new Predicate<Map<String, ServiceInfo>>(){

            @Override
            public boolean test(Map<String, ServiceInfo> map) {
                for (String ups : Arrays.asList(scoped, name)) {
                    if (!map.containsKey(ups)) continue;
                    return true;
                }
                return false;
            }
        }).map((Function)new Function<Map<String, ServiceInfo>, ServiceInfo>(){

            @Override
            public ServiceInfo apply(Map<String, ServiceInfo> t) {
                ServiceInfo si = t.get(scoped);
                return Objects.nonNull(si) ? si : t.get(name);
            }
        }).distinctUntilChanged(Function.identity(), UPSs::isEquals);
    }

    public void dispose() {
        this.cloudConnector.dispose();
    }
}

