/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.retry;

import com.turbospaces.annotations.Retryable;
import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.Bootstrap;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.context.ApplicationContext;

@Aspect
public class RetryAspect
extends AbstractBootstrapAware {
    private final ApplicationContext context;

    public RetryAspect(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    @Around(value="@within(com.turbospaces.annotations.Retryable)")
    public Object retryClass(ProceedingJoinPoint pjp) throws Throwable {
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        Class<?> declaringClass = method.getDeclaringClass();
        Retryable retry = declaringClass.getAnnotation(Retryable.class);
        return this.perform(pjp, retry, method);
    }

    @Around(value="execution (@com.turbospaces.annotations.Retryable * *.*(..))")
    public Object retryMethod(ProceedingJoinPoint pjp) throws Throwable {
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        Retryable retry = method.getAnnotation(Retryable.class);
        if (Objects.isNull(retry)) {
            method = pjp.getTarget().getClass().getMethod(method.getName(), method.getParameterTypes());
            retry = method.getAnnotation(Retryable.class);
        }
        return this.perform(pjp, retry, method);
    }

    private Object perform(ProceedingJoinPoint pjp, Retryable retryable, Method method) throws Throwable {
        String cfgName = StringUtils.isNotEmpty((CharSequence)retryable.config()) ? retryable.config() : "default";
        String retryName = method.getDeclaringClass().getSimpleName() + "_" + method.getName() + "_" + cfgName;
        Retry retry = null;
        try {
            retry = StringUtils.isNotEmpty((CharSequence)retryable.config()) ? this.bootstrap.retryRegistry().retry(retryName, (RetryConfig)this.context.getBean(retryable.config())) : this.bootstrap.retryRegistry().retry(retryName);
            retry.getEventPublisher().onRetry(event -> this.logger.warn("{} ", event, (Object)event.getLastThrowable()));
        }
        catch (Exception e) {
            this.logger.error("Error when resolving retry config {}, retry is not applied", (Object)retryable.config(), (Object)e);
        }
        if (retry == null) {
            return pjp.proceed();
        }
        return retry.executeCheckedSupplier(() -> ((ProceedingJoinPoint)pjp).proceed());
    }
}

