/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.executor;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.turbospaces.common.MDCUtil;
import com.turbospaces.executor.ContextWorker;
import com.turbospaces.executor.WorkUnit;
import io.netty.util.AsciiString;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedRunnable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SerialContextWorker
implements ContextWorker {
    private static final Logger log = LoggerFactory.getLogger(SerialContextWorker.class);
    private final AsciiString key;
    private final Executor executor;

    public SerialContextWorker(AsciiString key, ExecutorService executor) {
        this.key = Objects.requireNonNull(key);
        this.executor = MoreExecutors.newSequentialExecutor((Executor)executor);
    }

    @Override
    public ContextWorker forKey(WorkUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void execute(Runnable command) {
        Map mdcContextMap = MDC.getCopyOfContextMap();
        this.executor.execute(this.wrapRunnable(command, mdcContextMap));
    }

    @Override
    public ListenableFuture<?> submit(final CheckedRunnable command) {
        final long now = System.currentTimeMillis();
        final Map mdc = MDC.getCopyOfContextMap();
        final SettableFuture settable = SettableFuture.create();
        try {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread currentThread = Thread.currentThread();
                    String oldName = currentThread.getName();
                    String newName = oldName + "|" + SerialContextWorker.this.key;
                    currentThread.setName(newName);
                    MDCUtil.propagete(mdc);
                    try {
                        long delta = System.currentTimeMillis() - now;
                        if (delta > 0L) {
                            log.debug("task({}) was queued for {} ms before exec for key: {}", new Object[]{Math.abs(this.hashCode()), delta, SerialContextWorker.this.key});
                        }
                        command.run();
                        settable.set(new Object());
                    }
                    catch (Throwable err) {
                        settable.setException(err);
                    }
                    finally {
                        currentThread.setName(oldName);
                        MDC.clear();
                    }
                }
            });
        }
        catch (RejectedExecutionException err) {
            settable.setException((Throwable)err);
        }
        return settable;
    }

    @Override
    public <T> ListenableFuture<T> submit(final CheckedFunction0<T> command) {
        final long now = System.currentTimeMillis();
        final Map mdc = MDC.getCopyOfContextMap();
        final SettableFuture settable = SettableFuture.create();
        try {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread currentThread = Thread.currentThread();
                    String oldName = currentThread.getName();
                    String newName = oldName + "|" + SerialContextWorker.this.key;
                    currentThread.setName(newName);
                    MDCUtil.propagete(mdc);
                    try {
                        long delta = System.currentTimeMillis() - now;
                        if (delta > 0L) {
                            log.debug("task({}) was queued for {} ms before exec for key: {}", new Object[]{Math.abs(this.hashCode()), delta, SerialContextWorker.this.key});
                        }
                        settable.set(command.apply());
                    }
                    catch (Throwable err) {
                        settable.setException(err);
                    }
                    finally {
                        currentThread.setName(oldName);
                        MDC.clear();
                    }
                }
            });
        }
        catch (RejectedExecutionException err) {
            settable.setException((Throwable)err);
        }
        return settable;
    }
}

