/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.executor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.PlatformExecutorService;
import com.turbospaces.common.PlatformUtil;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.MDC;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DefaultPlatformExecutorService
extends AbstractBootstrapAware
implements PlatformExecutorService,
InitializingBean,
DisposableBean,
Supplier<ExecutorService> {
    private final String name;
    private final int minPoolSize;
    private final int maxPoolSize;
    private final RejectedExecutionHandler rejectPolicy;
    private ExecutorService executor;

    public DefaultPlatformExecutorService(String name, int minPoolSize, int maxPoolSize) {
        this.name = Objects.requireNonNull(name);
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.rejectPolicy = new ThreadPoolExecutor.AbortPolicy();
    }

    public DefaultPlatformExecutorService(String name, int minPoolSize, int maxPoolSize, RejectedExecutionHandler rejectPolicy) {
        this.name = Objects.requireNonNull(name);
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.rejectPolicy = Objects.requireNonNull(rejectPolicy);
    }

    public void afterPropertiesSet() {
        ThreadFactoryBuilder factory = new ThreadFactoryBuilder();
        factory.setDaemon(false);
        factory.setNameFormat(this.name + "-%d");
        ThreadFactory threadFactory = factory.build();
        Duration ttl = (Duration)this.bootstrap.props().APP_PLATFORM_MAX_IDLE.get();
        this.executor = new ThreadPoolExecutor(this.minPoolSize, this.maxPoolSize, ttl.getSeconds(), TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, this.rejectPolicy);
        ExecutorServiceMetrics metrics = new ExecutorServiceMetrics(this.executor, this.name, Collections.emptyList());
        metrics.bindTo(this.bootstrap.meterRegistry());
    }

    public void destroy() {
        StopWatch stopWatch = StopWatch.createStarted();
        Duration timeout = (Duration)this.bootstrap.props().APP_PLATFORM_GRACEFUL_SHUTDOWN_TIMEOUT.get();
        PlatformUtil.shutdownExecutor(this.executor, timeout);
        stopWatch.stop();
        this.logger.debug("stopped executor-service: {} in {}", (Object)this.executor, (Object)stopWatch);
    }

    @Override
    public void execute(Runnable command) {
        Map mdcContextMap = MDC.getCopyOfContextMap();
        this.executor.execute(this.wrapRunnable(command, mdcContextMap));
    }

    @VisibleForTesting
    public ExecutorService get() {
        return this.executor;
    }
}

