/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.MDC;

public class MDCUtil {
    public static ImmutableMap<String, String> propagete(Map<String, String> mdc) {
        if (Objects.nonNull(mdc)) {
            ImmutableMap.Builder toReturn = ImmutableMap.builder();
            for (Map.Entry<String, String> entry : mdc.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                String current = MDC.get((String)key);
                if (Objects.isNull(current)) {
                    MDC.put((String)key, (String)value);
                    toReturn.put((Object)key, (Object)value);
                    continue;
                }
                if (!Objects.equals(current, value)) continue;
                MDC.put((String)key, (String)value);
                toReturn.put((Object)key, (Object)value);
            }
            return toReturn.build();
        }
        return ImmutableMap.of();
    }

    public static void cleanUp(ImmutableMap<String, String> map) {
        if (Objects.nonNull(map)) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                String current = MDC.get((String)key);
                if (Objects.nonNull(current)) {
                    if (!Objects.equals(current, value)) continue;
                    MDC.remove((String)key);
                    continue;
                }
                MDC.remove((String)key);
            }
        }
    }

    private MDCUtil() {
    }
}

