/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckFilter;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.health.HealthCheckRegistryListener;
import com.codahale.metrics.jvm.ThreadDump;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Uninterruptibles;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.api.ConfigListener;
import com.netflix.archaius.config.DefaultConfigListener;
import com.netflix.archaius.config.PollingDynamicConfig;
import com.turbospaces.boot.AbstractHealtchCheck;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;
import com.turbospaces.boot.InjectBootstrapContextInitializer;
import com.turbospaces.boot.PlatformExecutorService;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.executor.DefaultPlatformExecutorService;
import com.turbospaces.executor.GlobalPlatformScheduledExecutorService;
import com.turbospaces.logging.AlertLoggingFilter;
import com.turbospaces.logging.Logback;
import com.turbospaces.ups.PlainServiceInfo;
import com.turbospaces.ups.UPSs;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.core.registry.EntryAddedEvent;
import io.github.resilience4j.micrometer.tagged.TaggedRateLimiterMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedRetryMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedTimeLimiterMetrics;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.jaegertracing.Configuration;
import io.jaegertracing.internal.JaegerTracer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmCompilationMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmInfoMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.OkHttpSender;
import io.micrometer.elastic.ElasticConfig;
import io.micrometer.elastic.ElasticMeterRegistry;
import io.micrometer.influx.InfluxConfig;
import io.micrometer.influx.InfluxMeterRegistry;
import io.opentracing.Tracer;
import io.sentry.SentryClient;
import io.sentry.SentryClientFactory;
import io.sentry.connection.EventSendCallback;
import io.sentry.event.Event;
import io.sentry.event.helper.ShouldSendEventCallback;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.URL;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.BootstrapContextClosedEvent;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.cloud.ConfigurableCloudConnector;
import org.springframework.cloud.ConfigurableCloudFactory;
import org.springframework.cloud.DynamicCloud;
import org.springframework.cloud.SmartCloudConnector;
import org.springframework.cloud.app.ApplicationInstanceInfo;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.cloud.service.UriBasedServiceInfo;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ResourceUtils;

public abstract class AbstractBootstrap<PROPS extends ApplicationProperties>
extends SpringApplication
implements Bootstrap {
    private final org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final MetricRegistry metricRegistry = new MetricRegistry();
    private final CompositeMeterRegistry meterRegistry = new CompositeMeterRegistry();
    private final ConcurrentHashMap<String, DefaultPlatformExecutorService> platforms = new ConcurrentHashMap();
    private final HealthCheckRegistry healthCheckRegistry;
    private final Thread shutdownHook;
    private final String release;
    private final ConfigurableCloudFactory cloudFactory;
    private final DynamicCloud cloud;
    private final PROPS props;
    private final GlobalPlatformScheduledExecutorService platform;
    private final JaegerTracer tracer;
    private final KeyStore keyStore;
    private final RetryRegistry retryRegistry;
    private final RateLimiterRegistry rateLimiterRegistry;
    private final TimeLimiterRegistry timeLimiterRegistry;
    private InputStream logFile;
    private GenericApplicationContext applicationContext;
    private SentryClient sentry;

    protected AbstractBootstrap(PROPS props, Class<?> ... mainClasses) throws Exception {
        this(props, new ConfigurableCloudConnector(), mainClasses);
    }

    protected AbstractBootstrap(final PROPS props, final SmartCloudConnector connector, Class<?> ... mainClasses) throws Exception {
        super((Class[])mainClasses);
        String[] infoByDefault;
        this.props = (ApplicationProperties)Objects.requireNonNull(props);
        this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        Duration backoffInitialInterval = (Duration)((ApplicationProperties)props).APP_BACKOFF_RETRY_FIRST.get();
        Duration backoffMaxInterval = (Duration)((ApplicationProperties)props).APP_BACKOFF_RETRY_MAX.get();
        int backoffMaxRetries = (Integer)((ApplicationProperties)props).APP_BACKOFF_RETRY_NUM.get();
        IntervalFunction backoff = IntervalFunction.ofExponentialBackoff((Duration)backoffInitialInterval, (double)1.5, (Duration)backoffMaxInterval);
        this.retryRegistry = RetryRegistry.of((RetryConfig)RetryConfig.custom().maxAttempts(backoffMaxRetries).intervalFunction(backoff).build());
        this.retryRegistry.getEventPublisher().onEntryAdded((EventConsumer)new EventConsumer<EntryAddedEvent<Retry>>(){

            public void consumeEvent(EntryAddedEvent<Retry> event) {
                Retry retry = (Retry)event.getAddedEntry();
                AbstractBootstrap.this.logger.debug("added new retry: {} with config: {}", (Object)retry.getName(), (Object)retry.getRetryConfig());
            }
        });
        this.rateLimiterRegistry = RateLimiterRegistry.ofDefaults();
        this.rateLimiterRegistry.getEventPublisher().onEntryAdded((EventConsumer)new EventConsumer<EntryAddedEvent<RateLimiter>>(){

            public void consumeEvent(EntryAddedEvent<RateLimiter> event) {
                RateLimiter rateLimiter = (RateLimiter)event.getAddedEntry();
                AbstractBootstrap.this.logger.debug("added new rate limiter: {} with config: {}", (Object)rateLimiter.getName(), (Object)rateLimiter.getRateLimiterConfig());
            }
        });
        this.timeLimiterRegistry = TimeLimiterRegistry.ofDefaults();
        this.timeLimiterRegistry.getEventPublisher().onEntryAdded((EventConsumer)new EventConsumer<EntryAddedEvent<TimeLimiter>>(){

            public void consumeEvent(EntryAddedEvent<TimeLimiter> event) {
                TimeLimiter timeLimiter = (TimeLimiter)event.getAddedEntry();
                AbstractBootstrap.this.logger.debug("added new time limiter: {} with config: {}", (Object)timeLimiter.getName(), (Object)timeLimiter.getTimeLimiterConfig());
            }
        });
        this.setWebApplicationType(WebApplicationType.NONE);
        this.setLogStartupInfo(false);
        this.setRegisterShutdownHook(false);
        connector.load((ApplicationProperties)props, this.keyStore(), this.retryRegistry());
        ApplicationInstanceInfo info = connector.getApplicationInstanceInfo();
        Map cloudProps = info.getProperties();
        final String space = cloudProps.get("cloud.application.space_name").toString();
        String host = cloudProps.get("cloud.application.host").toString();
        final String slot = cloudProps.get("cloud.application.instance_index").toString();
        final String service = info.getAppId();
        this.release = PlatformUtil.version(((ApplicationProperties)props).CLOUD_APP_NAME);
        this.platform = new GlobalPlatformScheduledExecutorService();
        this.platform.setBootstrap(this);
        this.platform.afterPropertiesSet();
        connector.getServiceInfos().forEach(new Consumer<ServiceInfo>(){

            @Override
            public void accept(ServiceInfo t) {
                if (t.getId().equals("sentry")) {
                    UriBasedServiceInfo serviceInfo = (UriBasedServiceInfo)t;
                    AbstractBootstrap.this.logger.info("about to init sentry from UPS: {}", (Object)serviceInfo.getId());
                    AbstractBootstrap.this.sentry = SentryClientFactory.sentryClient((String)serviceInfo.getUri());
                    AbstractBootstrap.this.sentry.setEnvironment(space);
                    AbstractBootstrap.this.sentry.setRelease(AbstractBootstrap.this.release);
                    AbstractBootstrap.this.sentry.setServerName(service + "/" + slot);
                    AbstractBootstrap.this.sentry.addShouldSendEventCallback(new ShouldSendEventCallback(){

                        public boolean shouldSend(Event event) {
                            return (Boolean)props.APP_SENTRY_ENABLED.get();
                        }
                    });
                    AbstractBootstrap.this.sentry.addEventSendCallback(new EventSendCallback(){

                        public void onSuccess(Event event) {
                            Counter counter = AbstractBootstrap.this.metricRegistry.counter(MetricRegistry.name((String)"sentry", (String[])new String[]{"success"}));
                            counter.inc();
                        }

                        public void onFailure(Event event, Exception exception) {
                            Counter counter = AbstractBootstrap.this.metricRegistry.counter(MetricRegistry.name((String)"sentry", (String[])new String[]{"failure"}));
                            counter.inc();
                        }
                    });
                }
            }
        });
        LoggerContext loggerFactory = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerFactory.setPackagingDataEnabled(this.isDevMode());
        for (String it : infoByDefault = new String[]{"org.eclipse.jgit"}) {
            Logger log = loggerFactory.getLogger(it);
            log.setLevel(Level.INFO);
        }
        this.cloudFactory = new ConfigurableCloudFactory(connector, (ApplicationProperties)props, this.retryRegistry(), new Consumer<String>(){

            @Override
            public void accept(String content) {
                try {
                    AbstractBootstrap.this.logFile = new ByteArrayInputStream(content.getBytes());
                    AbstractBootstrap.this.configureLogging(connector);
                }
                catch (Exception err) {
                    AbstractBootstrap.this.logger.error(err.getMessage(), (Throwable)err);
                }
            }
        });
        this.cloud = this.cloudFactory.getCloud();
        if (Objects.isNull(this.logFile)) {
            this.configureLogging(connector);
        }
        ImmutableMap.Builder tracingTags = ImmutableMap.builder();
        tracingTags.put((Object)"ip", (Object)PlatformUtil.detectIp());
        tracingTags.put((Object)"hostname", (Object)host);
        tracingTags.put((Object)"cloud.application.instance_index", (Object)slot);
        Configuration tracerCfg = Configuration.fromEnv((String)service).withTracerTags((Map)tracingTags.build());
        JaegerTracer.Builder tracerBuilder = tracerCfg.getTracerBuilder();
        tracerBuilder.withManualShutdown();
        this.tracer = tracerBuilder.build();
        ImmutableList.Builder meterTags = ImmutableList.builder();
        meterTags.add((Object)Tag.of((String)"env", (String)space));
        meterTags.add((Object)Tag.of((String)"release", (String)this.release));
        meterTags.add((Object)Tag.of((String)"service", (String)service));
        meterTags.add((Object)Tag.of((String)"host", (String)host));
        this.meterRegistry.config().commonTags((Iterable)meterTags.build());
        this.meterRegistry.add((MeterRegistry)new DropwizardMeterRegistry(new DropwizardConfig((ApplicationProperties)props){
            final /* synthetic */ ApplicationProperties val$props;
            {
                this.val$props = applicationProperties;
            }

            public String prefix() {
                return "boot";
            }

            public String get(String key) {
                return this.val$props.cfg().getString(key, null);
            }
        }, this.metricRegistry, HierarchicalNameMapper.DEFAULT, Clock.SYSTEM){

            protected Double nullGaugeValue() {
                return Double.NaN;
            }
        });
        LinkedList binders = Lists.newLinkedList();
        binders.add(new FileDescriptorMetrics());
        binders.add(new ClassLoaderMetrics());
        binders.add(new JvmGcMetrics());
        binders.add(new ProcessorMetrics());
        binders.add(new JvmThreadMetrics());
        binders.add(new JvmHeapPressureMetrics());
        binders.add(new JvmCompilationMetrics());
        binders.add(new JvmInfoMetrics());
        binders.add(new JvmMemoryMetrics());
        binders.add(new LogbackMetrics());
        if (BooleanUtils.isFalse((Boolean)((Boolean)((ApplicationProperties)props).APP_METRICS_DRY_RUN.get()))) {
            PlainServiceInfo si;
            Optional optelk = UPSs.findServiceInfoByName(this, "elastic-search");
            Optional optinf = UPSs.findServiceInfoByName(this, "influx");
            com.google.common.base.Supplier http = Suppliers.memoize((com.google.common.base.Supplier)new com.google.common.base.Supplier<OkHttpSender>(){

                public OkHttpSender get() {
                    OkHttpClient.Builder ok = new OkHttpClient.Builder();
                    ok.connectTimeout((Duration)props.TCP_CONNECTION_TIMEOUT.get());
                    ok.readTimeout((Duration)props.TCP_SOCKET_TIMEOUT.get());
                    ok.writeTimeout((Duration)props.TCP_SOCKET_TIMEOUT.get());
                    ok.retryOnConnectionFailure(true);
                    return new OkHttpSender(ok.build());
                }
            });
            if (optelk.isPresent()) {
                si = (PlainServiceInfo)((Object)optelk.get());
                if (((Boolean)((ApplicationProperties)props).APP_METRICS_ELK_REPORTER_ENABLED.get()).booleanValue()) {
                    this.meterRegistry.add((MeterRegistry)ElasticMeterRegistry.builder((ElasticConfig)new ElasticConfig((ApplicationProperties)props, si){
                        final /* synthetic */ ApplicationProperties val$props;
                        final /* synthetic */ PlainServiceInfo val$si;
                        {
                            this.val$props = applicationProperties;
                            this.val$si = plainServiceInfo;
                        }

                        public int batchSize() {
                            return (Integer)this.val$props.APP_METRICS_BULK_SIZE.get();
                        }

                        public String host() {
                            return String.format("%s://%s:%d", this.val$si.getScheme(), this.val$si.getHost(), this.val$si.getPort());
                        }

                        public String userName() {
                            return this.val$si.getUserName();
                        }

                        public String password() {
                            return this.val$si.getPassword();
                        }

                        public Duration connectTimeout() {
                            return (Duration)this.val$props.TCP_CONNECTION_TIMEOUT.get();
                        }

                        public Duration readTimeout() {
                            return (Duration)this.val$props.TCP_SOCKET_TIMEOUT.get();
                        }

                        public String get(String k) {
                            return this.val$props.cfg().getString(k, null);
                        }
                    }).httpClient((HttpSender)http.get()).build());
                }
            }
            if (optinf.isPresent()) {
                si = (PlainServiceInfo)((Object)optinf.get());
                if (((Boolean)((ApplicationProperties)props).APP_METRICS_INFLUX_REPORTER_ENABLED.get()).booleanValue()) {
                    this.meterRegistry.add((MeterRegistry)InfluxMeterRegistry.builder((InfluxConfig)new InfluxConfig((ApplicationProperties)props, si){
                        final /* synthetic */ ApplicationProperties val$props;
                        final /* synthetic */ PlainServiceInfo val$si;
                        {
                            this.val$props = applicationProperties;
                            this.val$si = plainServiceInfo;
                        }

                        public int batchSize() {
                            return (Integer)this.val$props.APP_METRICS_BULK_SIZE.get();
                        }

                        public String uri() {
                            return String.format("%s://%s:%d", this.val$si.getScheme(), this.val$si.getHost(), this.val$si.getPort());
                        }

                        public String userName() {
                            return this.val$si.getUserName();
                        }

                        public String password() {
                            return this.val$si.getPassword();
                        }

                        public String db() {
                            return this.val$si.getPath();
                        }

                        public String get(String k) {
                            return this.val$props.cfg().getString(k, null);
                        }
                    }).httpClient((HttpSender)http.get()).build());
                }
            }
        }
        for (MeterBinder binder : binders) {
            binder.bindTo(this.meterRegistry());
        }
        TaggedRetryMetrics.ofRetryRegistry((RetryRegistry)this.retryRegistry).bindTo((MeterRegistry)this.meterRegistry);
        TaggedRateLimiterMetrics.ofRateLimiterRegistry((RateLimiterRegistry)this.rateLimiterRegistry).bindTo((MeterRegistry)this.meterRegistry);
        TaggedTimeLimiterMetrics.ofTimeLimiterRegistry((TimeLimiterRegistry)this.timeLimiterRegistry).bindTo((MeterRegistry)this.meterRegistry);
        this.shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                AbstractBootstrap.this.logger.info("running shutdown hook now ...");
                try {
                    AbstractBootstrap.this.shutdown();
                }
                catch (Throwable err) {
                    AbstractBootstrap.this.logger.error(err.getMessage(), err);
                }
            }
        });
        this.healthCheckRegistry = new HealthCheckRegistry();
        this.healthCheckRegistry.addListener(new HealthCheckRegistryListener(){

            public void onHealthCheckAdded(String name, HealthCheck healthCheck) {
                if (healthCheck instanceof BootstrapAware) {
                    try {
                        ((BootstrapAware)healthCheck).setBootstrap(AbstractBootstrap.this);
                    }
                    catch (Exception err) {
                        ExceptionUtils.wrapAndThrow((Throwable)err);
                    }
                }
            }

            public void onHealthCheckRemoved(String name, HealthCheck healthCheck) {
                if (healthCheck instanceof AbstractHealtchCheck) {
                    AbstractHealtchCheck preDestoy = (AbstractHealtchCheck)healthCheck;
                    try {
                        preDestoy.destroy();
                    }
                    catch (Exception err) {
                        AbstractBootstrap.this.logger.error(err.getMessage(), (Throwable)err);
                    }
                }
            }
        });
    }

    @Override
    public ConfigurableApplicationContext run(String ... args) {
        boolean isHealthy = true;
        HashSet<String> unhealthy = new HashSet<String>();
        Lock rwLock = this.lock.writeLock();
        rwLock.lock();
        try {
            if (((Boolean)((ApplicationProperties)this.props).APP_WAIT_FOR_HEALTHCHECKS_ENABLED.get()).booleanValue()) {
                this.logger.debug("about to run health-checks now ...");
                int it = 0;
                long now = System.currentTimeMillis();
                long timeout = ((Duration)((ApplicationProperties)this.props).APP_WAIT_FOR_HEALTHCHECKS_TIMEOUT.get()).toMillis();
                isHealthy = false;
                while (System.currentTimeMillis() - now <= timeout) {
                    boolean tmp = true;
                    ++it;
                    unhealthy.clear();
                    for (Map.Entry entry : this.healthCheckRegistry().runHealthChecks(new HealthCheckFilter(){

                        public boolean matches(String name, HealthCheck healthCheck) {
                            if (healthCheck instanceof AbstractHealtchCheck) {
                                AbstractHealtchCheck check = (AbstractHealtchCheck)healthCheck;
                                return check.isBootstrapOnly();
                            }
                            return true;
                        }
                    }).entrySet()) {
                        this.logger.debug("iteration({}) ::: healthcheck({}) - isHealthy({})", new Object[]{it, entry.getKey(), ((HealthCheck.Result)entry.getValue()).isHealthy()});
                        tmp &= ((HealthCheck.Result)entry.getValue()).isHealthy();
                        if (((HealthCheck.Result)entry.getValue()).isHealthy()) continue;
                        unhealthy.add((String)entry.getKey());
                    }
                    if (tmp) {
                        isHealthy = true;
                        break;
                    }
                    int waitSec = (int)((Duration)((ApplicationProperties)this.props).APP_WAIT_FOR_HEALTHCHECKS_INTERVAL.get()).getSeconds();
                    this.logger.debug("about to wait {} sec before next health_check attempt ...", (Object)waitSec);
                    Uninterruptibles.sleepUninterruptibly((long)waitSec, (TimeUnit)TimeUnit.SECONDS);
                }
            }
            if (isHealthy) {
                long now = System.currentTimeMillis();
                this.logger.debug("about to perform actual application start ...");
                this.doStart(args);
                this.logger.info("application started in={} sec ...", (Object)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - now));
                if (((Boolean)((ApplicationProperties)this.props).APP_SHUTDOWN_HOOK_ENABLED.get()).booleanValue()) {
                    this.logger.info("shutdown hook has been registered ...");
                    Runtime.getRuntime().addShutdownHook(this.shutdownHook);
                }
                GenericApplicationContext genericApplicationContext = this.applicationContext;
                return genericApplicationContext;
            }
            try {
                this.logger.info("app will not start due to failed health checks ...");
                this.healthCheckRegistry.shutdown();
                if (Objects.nonNull(this.platform)) {
                    this.platform.destroy();
                }
                throw new Throwable("unhealthy = " + ((Object)unhealthy).toString());
            }
            catch (Throwable err) {
                boolean removed;
                if (isHealthy) {
                    this.logger.error(err.getMessage(), err);
                }
                if (removed = Runtime.getRuntime().removeShutdownHook(this.shutdownHook)) {
                    this.logger.info("removed shutdown hook ...");
                }
                if (isHealthy) {
                    this.logger.error("application failed to start, stopping lifecycle thread ...");
                    try {
                        this.shutdown();
                    }
                    catch (Throwable t) {
                        this.logger.warn(t.getMessage(), t);
                    }
                }
                this.logger.info("dumping all threads now before termination ... ");
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                ThreadDump dump = new ThreadDump(threadMXBean);
                dump.dump((OutputStream)System.err);
                Throwables.throwIfUnchecked((Throwable)err);
                throw new RuntimeException(err);
            }
        }
        finally {
            rwLock.unlock();
        }
    }

    @Override
    public void shutdown() throws Exception {
        Lock rwLock = this.lock.writeLock();
        rwLock.lock();
        try {
            this.doStop();
        }
        finally {
            rwLock.unlock();
        }
    }

    @Override
    public void exit(int code) {
        Lock rwLock = this.lock.writeLock();
        rwLock.lock();
        try {
            if (Objects.nonNull(this.shutdownHook)) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            System.exit(code);
        }
        finally {
            rwLock.unlock();
        }
    }

    @Override
    public void squashLogging() {
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)((ApplicationProperties)this.props).APP_LOGGING_RESET_TO.get()))) {
            Logback.resetToLevel((Level)Level.valueOf((String)((String)((ApplicationProperties)this.props).APP_LOGGING_RESET_TO.get())));
        }
    }

    @Override
    public void refreshCfg() throws Exception {
        this.cloudFactory.run();
    }

    public PROPS props() {
        return this.props;
    }

    @Override
    public ApplicationConfig cfg() {
        return this.props.cfg();
    }

    @Override
    public GlobalPlatformScheduledExecutorService globalPlatform() {
        return this.platform;
    }

    @Override
    public PlatformExecutorService platform(final String name) {
        return this.platforms.computeIfAbsent(name, new Function<String, DefaultPlatformExecutorService>(){

            @Override
            public DefaultPlatformExecutorService apply(String key) {
                int cores = Runtime.getRuntime().availableProcessors();
                int minPoolSize = AbstractBootstrap.this.props.cfg().getInteger(name + ".pool.min-size", 0);
                int maxPoolSize = AbstractBootstrap.this.props.cfg().getInteger(name + ".pool.max-size", Math.max(cores, (Integer)((ApplicationProperties)AbstractBootstrap.this.props).APP_DYNAMIC_PLATFORM_DEFAULT_MAX_SIZE.get()));
                DefaultPlatformExecutorService executor = new DefaultPlatformExecutorService(key, minPoolSize, maxPoolSize);
                executor.setBootstrap(AbstractBootstrap.this);
                executor.afterPropertiesSet();
                return executor;
            }
        });
    }

    @Override
    public Map<String, DefaultPlatformExecutorService> platforms() {
        return ImmutableMap.copyOf(this.platforms);
    }

    @Override
    public MetricRegistry metricRegistry() {
        return this.metricRegistry;
    }

    @Override
    public MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    @Override
    public HealthCheckRegistry healthCheckRegistry() {
        return this.healthCheckRegistry;
    }

    @Override
    public DynamicCloud cloud() {
        return this.cloud;
    }

    @Override
    public KeyStore keyStore() {
        return this.keyStore;
    }

    @Override
    public String release() {
        return this.release;
    }

    @Override
    public boolean isDevMode() {
        return (Boolean)((ApplicationProperties)this.props).APP_DEV_MODE.get();
    }

    @Override
    public int port() {
        return (Integer)((ApplicationProperties)this.props).CLOUD_APP_PORT.get();
    }

    @Override
    public int secondaryPort() {
        return (Integer)((ApplicationProperties)this.props).CLOUD_APP_SECONDARY_PORT.get();
    }

    @Override
    public int tertiaryPort() {
        return (Integer)((ApplicationProperties)this.props).CLOUD_APP_TERTIARY_PORT.get();
    }

    @Override
    public String spaceName() {
        return (String)((ApplicationProperties)this.props).CLOUD_APP_SPACE_NAME.get();
    }

    @Override
    public String appId() {
        return (String)((ApplicationProperties)this.props).CLOUD_APP_ID.get();
    }

    public void addBootstrapRegistryInitializer(BootstrapRegistryInitializer initializer) {
        if (initializer instanceof BootstrapAware) {
            ((BootstrapAware)initializer).setBootstrap(this);
        }
        super.addBootstrapRegistryInitializer(initializer);
    }

    @Override
    public void registerHealthCheck(String name, HealthCheck check) {
        this.healthCheckRegistry().register(name, check);
    }

    @Override
    public Tracer tracer() {
        return this.tracer;
    }

    @Override
    public RetryRegistry retryRegistry() {
        return this.retryRegistry;
    }

    @Override
    public RateLimiterRegistry rateLimiterRegistry() {
        return this.rateLimiterRegistry;
    }

    @Override
    public TimeLimiterRegistry timeLimiterRegistry() {
        return this.timeLimiterRegistry;
    }

    protected void configurePropertySources(ConfigurableEnvironment environment, String[] args) {
        super.configurePropertySources(environment, args);
        environment.getPropertySources().addFirst((PropertySource)new PropertySource<Object>("archaius"){

            public Object getProperty(String key) {
                return AbstractBootstrap.this.props().cfg().getRawProperty(key);
            }
        });
    }

    protected void postProcessApplicationContext(ConfigurableApplicationContext context) {
        super.postProcessApplicationContext(context);
    }

    protected void doStart(String ... args) throws Throwable {
        this.addBootstrapRegistryInitializer(new BootstrapRegistryInitializer(){

            public void initialize(BootstrapRegistry registry) {
                registry.addCloseListener((ApplicationListener)new ApplicationListener<BootstrapContextClosedEvent>(){

                    public void onApplicationEvent(BootstrapContextClosedEvent event) {
                        ConfigurableListableBeanFactory beanFactory = event.getApplicationContext().getBeanFactory();
                        beanFactory.registerSingleton("cloud", (Object)AbstractBootstrap.this.cloud());
                        beanFactory.registerSingleton("props", AbstractBootstrap.this.props());
                        beanFactory.registerSingleton("cfg", (Object)AbstractBootstrap.this.cfg());
                        beanFactory.registerSingleton("tracer", (Object)AbstractBootstrap.this.tracer());
                        beanFactory.registerSingleton("platform", (Object)AbstractBootstrap.this.globalPlatform());
                        beanFactory.registerSingleton("metric-registry", (Object)AbstractBootstrap.this.metricRegistry());
                        beanFactory.registerSingleton("health-check-registry", (Object)AbstractBootstrap.this.healthCheckRegistry());
                        beanFactory.registerSingleton("rate-limiter-registry", (Object)AbstractBootstrap.this.rateLimiterRegistry());
                        beanFactory.registerSingleton("time-limiter-registry", (Object)AbstractBootstrap.this.timeLimiterRegistry());
                        beanFactory.registerSingleton("retry-registry", (Object)AbstractBootstrap.this.retryRegistry());
                    }
                });
            }
        });
        this.addInitializers(new ApplicationContextInitializer[]{new InjectBootstrapContextInitializer(this)});
        this.applicationContext = (GenericApplicationContext)super.run(args);
    }

    protected void afterRefresh(ConfigurableApplicationContext context, ApplicationArguments args) {
        this.applicationContext = (GenericApplicationContext)context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        block21: {
            this.healthCheckRegistry.shutdown();
            for (String name : this.healthCheckRegistry.getNames()) {
                this.logger.info("removing health-check {} ...", (Object)name);
                this.healthCheckRegistry.unregister(name);
            }
            try {
                if (!Objects.nonNull(this.applicationContext)) break block21;
                this.logger.info("closing application now ...");
                this.applicationContext.close();
            }
            catch (Throwable throwable) {
                this.logger.info("shutting down platform now ...");
                this.platform.destroy();
                for (DefaultPlatformExecutorService it : this.platforms.values()) {
                    try {
                        it.destroy();
                    }
                    catch (Throwable t) {
                        this.logger.error(t.getMessage(), t);
                    }
                }
                for (Retry retry : this.retryRegistry.getAllRetries()) {
                    this.retryRegistry.remove(retry.getName());
                }
                for (RateLimiter rateLimiter : this.rateLimiterRegistry.getAllRateLimiters()) {
                    this.rateLimiterRegistry.remove(rateLimiter.getName());
                }
                for (TimeLimiter timeLimiter : this.timeLimiterRegistry.getAllTimeLimiters()) {
                    this.timeLimiterRegistry.remove(timeLimiter.getName());
                }
                if (Objects.nonNull(this.sentry)) {
                    this.logger.info("closing sentry now ...");
                    this.sentry.closeConnection();
                }
                this.meterRegistry.close();
                this.meterRegistry.clear();
                this.tracer.close();
                this.cloud.dispose();
                if (((Boolean)((ApplicationProperties)this.props).APP_CLEAR_CONFIG_AT_SHUTDOWN_ENABLED.get()).booleanValue()) {
                    this.logger.debug("disposing CFG ...");
                    ApplicationConfig cfg = this.props.cfg();
                    for (String next : cfg.getConfigNames()) {
                        Config removed = cfg.removeConfig(next);
                        if (!(removed instanceof PollingDynamicConfig)) continue;
                        PollingDynamicConfig pdc = (PollingDynamicConfig)removed;
                        pdc.shutdown();
                    }
                }
                throw throwable;
            }
        }
        this.logger.info("shutting down platform now ...");
        this.platform.destroy();
        for (DefaultPlatformExecutorService it : this.platforms.values()) {
            try {
                it.destroy();
            }
            catch (Throwable t) {
                this.logger.error(t.getMessage(), t);
            }
        }
        for (Retry retry : this.retryRegistry.getAllRetries()) {
            this.retryRegistry.remove(retry.getName());
        }
        for (RateLimiter rateLimiter : this.rateLimiterRegistry.getAllRateLimiters()) {
            this.rateLimiterRegistry.remove(rateLimiter.getName());
        }
        for (TimeLimiter timeLimiter : this.timeLimiterRegistry.getAllTimeLimiters()) {
            this.timeLimiterRegistry.remove(timeLimiter.getName());
        }
        if (Objects.nonNull(this.sentry)) {
            this.logger.info("closing sentry now ...");
            this.sentry.closeConnection();
        }
        this.meterRegistry.close();
        this.meterRegistry.clear();
        this.tracer.close();
        this.cloud.dispose();
        if (((Boolean)((ApplicationProperties)this.props).APP_CLEAR_CONFIG_AT_SHUTDOWN_ENABLED.get()).booleanValue()) {
            this.logger.debug("disposing CFG ...");
            ApplicationConfig cfg = this.props.cfg();
            for (String next : cfg.getConfigNames()) {
                Config removed = cfg.removeConfig(next);
                if (!(removed instanceof PollingDynamicConfig)) continue;
                PollingDynamicConfig pdc = (PollingDynamicConfig)removed;
                pdc.shutdown();
            }
        }
    }

    private void configureLogging(SmartCloudConnector connector) throws Exception {
        ApplicationInstanceInfo info = connector.getApplicationInstanceInfo();
        Map cloudProps = info.getProperties();
        String space = cloudProps.get("cloud.application.space_name").toString();
        String host = cloudProps.get("cloud.application.host").toString();
        String slot = cloudProps.get("cloud.application.instance_index").toString();
        String service = info.getAppId();
        LoggerContext loggerFactory = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerFactory.setPackagingDataEnabled(this.isDevMode());
        boolean toConfigure = true;
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("space", space);
        options.put("host", host);
        options.put("service", service);
        options.put("slot", slot);
        options.put("release", this.release());
        HashMap copyOfCfg = Maps.newHashMap();
        Iterator keys = this.cfg().getKeys();
        while (keys.hasNext()) {
            String next = (String)keys.next();
            Object raw = this.cfg().getRawProperty(next);
            copyOfCfg.put(next, raw);
        }
        final AtomicBoolean logging = new AtomicBoolean((Boolean)((ApplicationProperties)this.props()).APP_LOGGING_DRY_RUN.get());
        final AtomicBoolean alerts = new AtomicBoolean((Boolean)((ApplicationProperties)this.props()).APP_ALERTS_DRY_RUN.get());
        Config git = this.cfg().getConfig("core.GIT_CFG");
        git.addListener((ConfigListener)new DefaultConfigListener(){

            public void onConfigUpdated(Config config) {
                String klog = ((ApplicationProperties)AbstractBootstrap.this.props).APP_LOGGING_DRY_RUN.getKey();
                String kalert = ((ApplicationProperties)AbstractBootstrap.this.props).APP_ALERTS_DRY_RUN.getKey();
                if (config.containsKey(klog)) {
                    boolean updated = config.getBoolean(klog);
                    logging.set(updated);
                } else if (config.containsKey(kalert)) {
                    boolean updated = config.getBoolean(kalert);
                    alerts.set(updated);
                }
            }
        });
        Supplier<Boolean> loggingDryRun = new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return logging.get();
            }
        };
        Supplier<Boolean> alertsDryRun = new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return alerts.get();
            }
        };
        if (((Boolean)((ApplicationProperties)this.props()).APP_DEV_MODE.get()).booleanValue()) {
            try {
                URL logbackTest = ResourceUtils.getURL((String)"classpath:logback-test.xml");
                try (InputStream io = logbackTest.openStream();){
                    toConfigure = false;
                }
            }
            catch (FileNotFoundException logbackTest) {
                // empty catch block
            }
        }
        if (toConfigure) {
            AlertLoggingFilter alertFilter = new AlertLoggingFilter(((ApplicationProperties)this.props).SENTRY_ALERTS_FILTER_ENABLED, ((ApplicationProperties)this.props).SENTRY_ALERTS_EX_CLASSES_TO_IGNORE, ((ApplicationProperties)this.props).SENTRY_ALERTS_EX_MSGS_TO_IGNORE, ((ApplicationProperties)this.props).SENTRY_ALERTS_EX_PATTERNS_TO_IGNORE, ((ApplicationProperties)this.props).SENTRY_ALERTS_LOG_MESSAGES_TO_IGNORE, ((ApplicationProperties)this.props).SENTRY_ALERTS_LOGGERS_TO_IGNORE);
            AtomicReference sentryUps = new AtomicReference();
            AtomicReference elasticUps = new AtomicReference();
            connector.getServiceInfos().forEach(si -> {
                switch (si.getId()) {
                    case "sentry": {
                        sentryUps.set((UriBasedServiceInfo)si);
                        break;
                    }
                    case "elastic-search": {
                        elasticUps.set((UriBasedServiceInfo)si);
                        break;
                    }
                }
            });
            if (Objects.nonNull(this.logFile)) {
                try (InputStream io = this.logFile;){
                    Logback.configureFrom((LoggerContext)loggerFactory, (AlertLoggingFilter)alertFilter, (InputStream)io, options, (SentryClient)this.sentry, (MeterRegistry)this.meterRegistry, (Map)copyOfCfg, (Supplier)loggingDryRun, (Supplier)alertsDryRun, (UriBasedServiceInfo)((UriBasedServiceInfo)sentryUps.get()), (UriBasedServiceInfo)((UriBasedServiceInfo)elasticUps.get()));
                }
            }
            try {
                URL loggingXml = ResourceUtils.getURL((String)"classpath:logging.xml");
                try (InputStream io = loggingXml.openStream();){
                    Logback.configureFrom((LoggerContext)loggerFactory, (AlertLoggingFilter)alertFilter, (InputStream)io, options, (SentryClient)this.sentry, (MeterRegistry)this.meterRegistry, (Map)copyOfCfg, (Supplier)loggingDryRun, (Supplier)alertsDryRun, (UriBasedServiceInfo)((UriBasedServiceInfo)sentryUps.get()), (UriBasedServiceInfo)((UriBasedServiceInfo)elasticUps.get()));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

