/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.turbospaces.common.CompletableRequestReplyMapper;
import com.turbospaces.common.RequestReplyTimeout;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletableRequestReplyMapperTest {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    CompletableRequestReplyMapper<String, Long> mapper;

    @BeforeEach
    public void before() {
        this.mapper = new CompletableRequestReplyMapper();
        this.mapper.afterPropertiesSet();
    }

    @AfterEach
    public void after() throws Exception {
        this.mapper.destroy();
    }

    @Test
    public void works() throws InterruptedException {
        String key = RandomStringUtils.randomAlphanumeric((int)4);
        final CountDownLatch l = new CountDownLatch(1);
        SettableFuture f = this.mapper.acquire((Object)key, Duration.ofSeconds(15L));
        f.addListener(new Runnable(){

            @Override
            public void run() {
                l.countDown();
            }
        }, MoreExecutors.directExecutor());
        Assertions.assertEquals((int)1, (int)this.mapper.pendingCount());
        this.mapper.complete((Object)key, (Object)System.currentTimeMillis());
        l.await();
        Assertions.assertEquals((int)0, (int)this.mapper.pendingCount());
    }

    @Test
    public void timeoutRaw() throws InterruptedException {
        String key = RandomStringUtils.randomAlphanumeric((int)4);
        CountDownLatch l = new CountDownLatch(1);
        SettableFuture f = this.mapper.acquire((Object)key, Duration.ofMillis(1L));
        f.addListener(new Runnable((ListenableFuture)f, l){
            final /* synthetic */ ListenableFuture val$f;
            final /* synthetic */ CountDownLatch val$l;
            {
                this.val$f = listenableFuture;
                this.val$l = countDownLatch;
            }

            @Override
            public void run() {
                try {
                    this.val$f.get();
                }
                catch (Exception err) {
                    RequestReplyTimeout timeout = (RequestReplyTimeout)err.getCause();
                    CompletableRequestReplyMapperTest.this.logger.error(timeout.getMessage(), (Throwable)timeout);
                    this.val$l.countDown();
                }
            }
        }, MoreExecutors.directExecutor());
        l.await();
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(1L)).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CompletableRequestReplyMapperTest.this.mapper.pendingCount() == 0;
            }
        });
    }

    @Test
    public void timeoutFluent() throws InterruptedException {
        String key = RandomStringUtils.randomAlphanumeric((int)4);
        final CountDownLatch l = new CountDownLatch(1);
        FluentFuture f = FluentFuture.from((ListenableFuture)this.mapper.acquire((Object)key, Duration.ofMillis(1L)));
        f.addCallback((FutureCallback)new FutureCallback<Long>(){

            public void onSuccess(Long result) {
            }

            public void onFailure(Throwable t) {
                RequestReplyTimeout timeout = (RequestReplyTimeout)ExceptionUtils.getRootCause((Throwable)t);
                CompletableRequestReplyMapperTest.this.logger.error(timeout.getMessage(), (Throwable)timeout);
                l.countDown();
            }
        }, this.mapper);
        l.await();
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(1L)).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CompletableRequestReplyMapperTest.this.mapper.pendingCount() == 0;
            }
        });
    }

    @Test
    public void exceptionally() throws InterruptedException {
        String key = RandomStringUtils.randomAlphanumeric((int)4);
        final CountDownLatch l = new CountDownLatch(1);
        FluentFuture f = FluentFuture.from((ListenableFuture)this.mapper.acquire((Object)key, Duration.ofMinutes(1L)));
        f.addCallback((FutureCallback)new FutureCallback<Long>(){

            public void onSuccess(Long result) {
            }

            public void onFailure(Throwable t) {
                l.countDown();
            }
        }, this.mapper);
        this.mapper.completeExceptionally((Object)key, (Throwable)new IllegalStateException());
        l.await();
        Awaitility.waitAtMost((Duration)Duration.ofSeconds(1L)).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CompletableRequestReplyMapperTest.this.mapper.pendingCount() == 0;
            }
        });
    }
}

