/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.executor;

import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.BootstrapAware;
import com.turbospaces.executor.ContextWorker;
import com.turbospaces.executor.WorkUnit;
import io.netty.util.AsciiString;
import io.vavr.CheckedRunnable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.MDC;

public class SerialContextWorker
extends AbstractBootstrapAware
implements ContextWorker {
    private final Object mutex = new Object();
    private final Queue<Runnable> queue = new LinkedList<Runnable>();
    private final AsciiString key;
    private final ExecutorService executor;
    private Runnable active;

    public SerialContextWorker(AsciiString key, ExecutorService executor) {
        this.key = Objects.requireNonNull(key);
        this.executor = Objects.requireNonNull(executor);
    }

    @Override
    public ExecutorService executor() {
        return this.executor;
    }

    @Override
    public ContextWorker forKey(WorkUnit unit) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(final CheckedRunnable command) {
        if (command instanceof AbstractBootstrapAware) {
            ((BootstrapAware)command).setBootstrap(this.bootstrap);
        }
        Object object = this.mutex;
        synchronized (object) {
            final long now = System.currentTimeMillis();
            final Map mdc = MDC.getCopyOfContextMap();
            this.queue.add(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread currentThread = Thread.currentThread();
                    String oldName = currentThread.getName();
                    String newName = oldName + "|" + SerialContextWorker.this.key;
                    currentThread.setName(newName);
                    try {
                        long delta;
                        if (mdc != null) {
                            for (Map.Entry entry : mdc.entrySet()) {
                                MDC.put((String)((String)entry.getKey()), (String)((String)entry.getValue()));
                            }
                        }
                        if ((delta = System.currentTimeMillis() - now) > 0L) {
                            SerialContextWorker.this.logger.debug("task({}) was queued for {} ms before exec for key: {}", new Object[]{Math.abs(this.hashCode()), delta, SerialContextWorker.this.key});
                        }
                        SerialContextWorker.this.logger.trace("before apply: {}", (Object)command);
                        command.run();
                    }
                    catch (Throwable err) {
                        SerialContextWorker.this.logger.error(err.getMessage(), err);
                        ExceptionUtils.wrapAndThrow((Throwable)err);
                    }
                    finally {
                        currentThread.setName(oldName);
                        if (mdc != null) {
                            for (String string : mdc.keySet()) {
                                MDC.remove((String)string);
                            }
                        }
                        SerialContextWorker.this.scheduleNext();
                    }
                }
            });
            if (Objects.isNull(this.active)) {
                this.scheduleNext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNext() {
        Object object = this.mutex;
        synchronized (object) {
            this.active = this.queue.poll();
            if (this.active != null) {
                this.logger.debug("submitting task by key: {}, queue size: {}, executor: {}", new Object[]{this.key, this.queue.size(), this.executor});
                this.executor.execute(this.active);
            }
        }
    }
}

