/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common;

import com.turbospaces.common.RequestReplyFuture;
import com.turbospaces.common.RequestReplyMapper;
import com.turbospaces.common.RequestReplyTimeout;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class CompletableRequestReplyMapper<K, V>
extends ThreadPoolTaskScheduler
implements RequestReplyMapper<K, V> {
    private static final Logger log = LoggerFactory.getLogger(CompletableRequestReplyMapper.class);
    private final ConcurrentMap<K, CompletableFuture<V>> corr = new ConcurrentHashMap<K, CompletableFuture<V>>();

    public CompletableRequestReplyMapper() {
        this.setDaemon(true);
        this.setRemoveOnCancelPolicy(true);
        this.setPoolSize(Runtime.getRuntime().availableProcessors());
    }

    @Override
    public CompletableFuture<V> acquire(final K key, final int timeout, final TimeUnit unit) {
        boolean duplicate;
        StopWatch stopWatch;
        final Map mdc = MDC.getCopyOfContextMap();
        ScheduledFuture timeoutTask = this.schedule(new Runnable(){

            @Override
            public void run() {
                CompletableFuture tmp = (CompletableFuture)CompletableRequestReplyMapper.this.corr.remove(key);
                if (tmp != null && BooleanUtils.isFalse((Boolean)tmp.isDone())) {
                    if (mdc != null) {
                        MDC.setContextMap((Map)mdc);
                    }
                    try {
                        RequestReplyTimeout timeoutException = new RequestReplyTimeout(timeout, unit, key);
                        tmp.completeExceptionally(timeoutException);
                        log.debug("request-reply(m={}) removing subj due to timeout", key);
                    }
                    catch (Exception err) {
                        log.error(err.getMessage(), (Throwable)err);
                    }
                    finally {
                        MDC.clear();
                    }
                }
            }
        }, Instant.now().plusSeconds(timeout));
        CompletionStage toReturn = new RequestReplyFuture(key, timeoutTask).whenComplete(new BiConsumer<V, Throwable>(stopWatch = StopWatch.createStarted(), key){
            final /* synthetic */ StopWatch val$stopWatch;
            final /* synthetic */ Object val$key;
            {
                this.val$stopWatch = stopWatch;
                this.val$key = object;
            }

            @Override
            public void accept(V resp, Throwable err) {
                if (Objects.isNull(err)) {
                    this.val$stopWatch.stop();
                    log.debug("request-reply(m={}) completed in {}", this.val$key, (Object)this.val$stopWatch);
                }
            }
        });
        boolean bl = duplicate = this.corr.putIfAbsent(key, (CompletableFuture<CompletionStage>)toReturn) != null;
        if (duplicate) {
            timeoutTask.cancel(true);
            throw new RuntimeException("duplicate key violation corrId: " + key);
        }
        return toReturn;
    }

    @Override
    public boolean complete(K key, V value) {
        CompletableFuture subj = (CompletableFuture)this.corr.remove(Objects.requireNonNull(key));
        if (subj != null) {
            subj.complete(value);
            return true;
        }
        log.trace("no such correlation for key: {}", key);
        return false;
    }

    @Override
    public void completeExceptionally(K key, Throwable reason) {
        CompletableFuture subj = (CompletableFuture)this.corr.remove(Objects.requireNonNull(key));
        if (subj != null) {
            subj.completeExceptionally(reason);
        }
    }

    @Override
    public void clear() {
        this.corr.clear();
    }

    @Override
    public int pendingCount() {
        return this.corr.size();
    }
}

