/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common;

import com.turbospaces.common.CompletableRequestReplyMapper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletableRequestReplyMapperTest {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    CompletableRequestReplyMapper<String, Long> mapper;

    @BeforeEach
    public void before() {
        this.mapper = new CompletableRequestReplyMapper();
        this.mapper.afterPropertiesSet();
    }

    @AfterEach
    public void after() throws Exception {
        this.mapper.destroy();
    }

    @Test
    public void works() throws InterruptedException {
        String key = RandomStringUtils.randomAlphanumeric((int)4);
        final CountDownLatch l = new CountDownLatch(1);
        CompletableFuture f = this.mapper.acquire((Object)key, 15, TimeUnit.SECONDS);
        f.whenCompleteAsync(new BiConsumer<Long, Throwable>(){

            @Override
            public void accept(Long value, Throwable t) {
                if (value != null) {
                    l.countDown();
                }
            }
        });
        Assertions.assertEquals((int)1, (int)this.mapper.pendingCount());
        this.mapper.complete((Object)key, (Object)System.currentTimeMillis());
        l.await();
        Assertions.assertEquals((int)0, (int)this.mapper.pendingCount());
    }

    @Test
    public void timeout() throws InterruptedException {
        String key = RandomStringUtils.randomAlphanumeric((int)4);
        final CountDownLatch l = new CountDownLatch(1);
        CompletableFuture f = this.mapper.acquire((Object)key, 1, TimeUnit.SECONDS);
        f.whenCompleteAsync(new BiConsumer<Long, Throwable>(){

            @Override
            public void accept(Long value, Throwable t) {
                if (t != null) {
                    CompletableRequestReplyMapperTest.this.logger.error(t.getMessage(), t);
                    l.countDown();
                }
            }
        });
        l.await();
        Thread.sleep(100L);
        Assertions.assertEquals((int)0, (int)this.mapper.pendingCount());
    }
}

