package com.turbospaces.executor;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Executors {
    public static ExecutorService newScalingThreadPool(int min, int max, Duration keepAlive, ThreadFactory tf) {
        ScalingQueue<Runnable> queue = new ScalingQueue<>();
        ThreadPoolExecutor executor = new ScalingThreadPoolExecutor(min, max, keepAlive.toMillis(), TimeUnit.MILLISECONDS, queue);
        executor.setRejectedExecutionHandler(new ForceQueuePolicy());
        executor.setThreadFactory(tf);
        queue.setThreadPoolExecutor(executor);
        return executor;
    }
}
