/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.executor;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.BootstrapAware;
import com.turbospaces.executor.ContextWorker;
import com.turbospaces.executor.SerialContextWorker;
import com.turbospaces.executor.WorkUnit;
import io.netty.util.AsciiString;
import io.vavr.CheckedRunnable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.MDC;

public class ThreadPoolContextWorker
extends AbstractBootstrapAware
implements ContextWorker {
    private final LoadingCache<AsciiString, SerialContextWorker> executors;
    private final ExecutorService executor;

    public ThreadPoolContextWorker(final ExecutorService executor) {
        this.executor = Objects.requireNonNull(executor);
        this.executors = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<AsciiString, SerialContextWorker>(){

            public SerialContextWorker load(AsciiString key) {
                SerialContextWorker serial = new SerialContextWorker(key, executor);
                serial.setBootstrap(ThreadPoolContextWorker.this.bootstrap);
                return serial;
            }
        });
    }

    @Override
    public ExecutorService executor() {
        return this.executor;
    }

    @Override
    public ContextWorker forKey(WorkUnit unit) {
        AsciiString partitionKey = new AsciiString(unit.key());
        return (ContextWorker)this.executors.getUnchecked((Object)partitionKey);
    }

    @Override
    public void schedule(final CheckedRunnable command) {
        Map mdc;
        if (command instanceof BootstrapAware) {
            ((BootstrapAware)command).setBootstrap(this.bootstrap);
        }
        if ((mdc = MDC.getCopyOfContextMap()) != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (mdc != null) {
                        for (Map.Entry entry : mdc.entrySet()) {
                            MDC.put((String)((String)entry.getKey()), (String)((String)entry.getValue()));
                        }
                    }
                    try {
                        command.run();
                    }
                    catch (Throwable err) {
                        ThreadPoolContextWorker.this.logger.error(err.getMessage(), err);
                        ExceptionUtils.wrapAndThrow((Throwable)err);
                    }
                    finally {
                        if (mdc != null) {
                            for (String string : mdc.keySet()) {
                                MDC.remove((String)string);
                            }
                        }
                    }
                }
            });
        } else {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ThreadPoolContextWorker.this.logger.debug("before apply: {}", (Object)command);
                        command.run();
                    }
                    catch (Throwable err) {
                        ThreadPoolContextWorker.this.logger.error(err.getMessage(), err);
                        ExceptionUtils.wrapAndThrow((Throwable)err);
                    }
                }
            });
        }
    }
}

