/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.DefaultPlatformExecutorService;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import io.vavr.CheckedRunnable;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurablePlatformTest {
    private static final Logger log = LoggerFactory.getLogger(ConfigurablePlatformTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void works() throws Exception {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        cfg.setLocalProperty(props.APP_PLATFORM_GRACEFUL_SHUTDOWN_TIMEOUT.getKey(), (Object)Duration.ofSeconds(1L));
        SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.run(new String[0]);
        DefaultPlatformExecutorService platform = new DefaultPlatformExecutorService("test", 1, 2);
        platform.setBootstrap((Bootstrap)bootstrap);
        platform.afterPropertiesSet();
        try {
            final CountDownLatch semaphore = new CountDownLatch(1);
            final CountDownLatch l = new CountDownLatch(1);
            final CountDownLatch interrupted = new CountDownLatch(1);
            platform.execute(new CheckedRunnable(){

                public void run() throws Exception {
                    System.out.println("work");
                    semaphore.await();
                    l.countDown();
                }
            });
            platform.execute(new Runnable(){

                @Override
                public void run() {
                    System.out.println("execute");
                    semaphore.countDown();
                }
            });
            l.await();
            final CountDownLatch started = new CountDownLatch(1);
            platform.execute(new CheckedRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    3 var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            log.debug("about to hang forever ...");
                            Thread.sleep(1000L);
                            log.debug("count down to mark started ...");
                            started.countDown();
                            this.wait();
                        }
                        catch (InterruptedException err) {
                            interrupted.countDown();
                        }
                    }
                }
            });
            started.await();
            platform.destroy();
            interrupted.await();
        }
        finally {
            bootstrap.shutdown();
        }
    }
}

