package com.turbospaces.executor;

import java.util.Objects;
import java.util.concurrent.ExecutorService;

import io.vavr.CheckedRunnable;

public interface ContextWorker {
    ExecutorService executor();
    ContextWorker forKey(WorkUnit unit);
    void schedule(CheckedRunnable command);

    default ContextWorker ifPresent(WorkUnit unit) {
        if (Objects.nonNull(unit.key())) {
            return actor(unit);
        }
        return this;
    }
    default ContextWorker actor(WorkUnit unit) {
        return forKey(unit);
    }
}
