package com.turbospaces.boot;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;

import org.slf4j.MDC;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;

import io.vavr.CheckedRunnable;

public interface PlatformExecutorService extends ListeningExecutorService, InitializingBean, DisposableBean {
    ListenableFuture<?> execute(CheckedRunnable action);

    default Map<String, String> getMdcContextMap() {
        return Optional.ofNullable(MDC.getCopyOfContextMap()).orElse(Collections.emptyMap());
    }
    default void setMDCContext(Map<String, String> contextMap) {
        MDC.clear();
        if (contextMap != null) {
            MDC.setContextMap(contextMap);
        }
    }
    default Runnable wrapRunnable(Runnable task, Map<String, String> mdcContextMap) {
        return new Runnable() {
            @Override
            public void run() {
                setMDCContext(mdcContextMap);
                try {
                    task.run();
                } finally {
                    MDC.clear();
                }
            }
        };
    }
    default <V> Callable<V> wrapCallable(Callable<V> task, Map<String, String> mdcContextMap) {
        return new Callable<V>() {
            @Override
            public V call() throws Exception {
                setMDCContext(mdcContextMap);
                try {
                    return task.call();
                } finally {
                    MDC.clear();
                }
            }
        };
    }
}
