/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import io.vavr.CheckedRunnable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.slf4j.MDC;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public interface PlatformExecutorService
extends ListeningExecutorService,
InitializingBean,
DisposableBean {
    public ListenableFuture<?> execute(CheckedRunnable var1);

    default public Map<String, String> getMdcContextMap() {
        return Optional.ofNullable(MDC.getCopyOfContextMap()).orElse(Collections.emptyMap());
    }

    default public void setMDCContext(Map<String, String> contextMap) {
        MDC.clear();
        if (contextMap != null) {
            MDC.setContextMap(contextMap);
        }
    }

    default public Runnable wrapRunnable(final Runnable task, final Map<String, String> mdcContextMap) {
        return new Runnable(){

            @Override
            public void run() {
                PlatformExecutorService.this.setMDCContext(mdcContextMap);
                try {
                    task.run();
                }
                finally {
                    MDC.clear();
                }
            }
        };
    }

    default public <V> Callable<V> wrapCallable(final Callable<V> task, final Map<String, String> mdcContextMap) {
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                PlatformExecutorService.this.setMDCContext(mdcContextMap);
                try {
                    Object v = task.call();
                    return v;
                }
                finally {
                    MDC.clear();
                }
            }
        };
    }
}

