/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.PlatformExecutorService;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.executor.Executors;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.vavr.CheckedRunnable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPlatformExecutorService
extends AbstractBootstrapAware
implements PlatformExecutorService {
    private static final Logger log = LoggerFactory.getLogger(DefaultPlatformExecutorService.class);
    private final String name;
    private final int minPoolSize;
    private final int maxPoolSize;
    private ListeningExecutorService executor;

    public DefaultPlatformExecutorService(String name, int minPoolSize, int maxPoolSize) {
        this.name = Objects.requireNonNull(name);
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
    }

    public void afterPropertiesSet() {
        ThreadFactoryBuilder factory = new ThreadFactoryBuilder();
        factory.setDaemon(false);
        factory.setNameFormat(this.name + "-%d");
        ThreadFactory threadFactory = factory.build();
        Duration ttl = (Duration)this.bootstrap.props().APP_PLATFORM_MAX_IDLE.get();
        ExecutorService pool = Executors.newScalingThreadPool(this.minPoolSize, this.maxPoolSize, ttl, threadFactory);
        ExecutorServiceMetrics metrics = new ExecutorServiceMetrics(pool, this.name, Collections.emptyList());
        metrics.bindTo(this.bootstrap.meterRegistry());
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)pool);
    }

    public void destroy() {
        StopWatch stopWatch = StopWatch.createStarted();
        Duration timeout = (Duration)this.bootstrap.props().APP_PLATFORM_GRACEFUL_SHUTDOWN_TIMEOUT.get();
        PlatformUtil.shutdownExecutor((ExecutorService)this.executor, timeout);
        stopWatch.stop();
        this.logger.debug("stopped executor-service: {} in {}", (Object)this.executor, (Object)stopWatch);
    }

    @Override
    public ListenableFuture<?> execute(final CheckedRunnable action) {
        return this.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    action.run();
                }
                catch (Throwable err) {
                    log.error(err.getMessage(), err);
                }
            }
        });
    }

    public void execute(Runnable command) {
        Map mdcContextMap = this.getMdcContextMap();
        this.executor.execute(this.wrapRunnable(command, mdcContextMap));
    }

    public ListenableFuture<?> submit(Runnable task) {
        Map mdcContextMap = this.getMdcContextMap();
        return this.executor.submit(this.wrapRunnable(task, mdcContextMap));
    }

    public <T> ListenableFuture<T> submit(Callable<T> task) {
        Map mdcContextMap = this.getMdcContextMap();
        return this.executor.submit(this.wrapCallable(task, mdcContextMap));
    }

    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        Map mdcContextMap = this.getMdcContextMap();
        return this.executor.submit(this.wrapRunnable(task, mdcContextMap), result);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executor.invokeAll(tasks);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.invokeAll(tasks, timeout, unit);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.executor.invokeAny(tasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.executor.invokeAny(tasks, timeout, unit);
    }
}

