/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.turbospaces.boot.FixedSizePlatform;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.vavr.CheckedRunnable;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformTest {
    @Test
    public void works() throws Exception {
        final Logger logger = LoggerFactory.getLogger(this.getClass());
        ApplicationConfig cfg = ApplicationConfig.create((Duration)Duration.ofDays(1L));
        ApplicationProperties props = new ApplicationProperties(cfg);
        cfg.setLocalProperty(props.APP_PLATFORM_GRACEFUL_SHUTDOWN_TIMEOUT.getKey(), (Object)Duration.ofSeconds(1L));
        SimpleMeterRegistry registry = new SimpleMeterRegistry();
        FixedSizePlatform platform = new FixedSizePlatform(new ApplicationProperties(cfg), (MeterRegistry)registry);
        final CountDownLatch semaphore = new CountDownLatch(1);
        final CountDownLatch l = new CountDownLatch(1);
        final CountDownLatch interrupted = new CountDownLatch(1);
        platform.work(new CheckedRunnable(){

            public void run() throws Exception {
                semaphore.await();
                l.countDown();
            }
        });
        platform.execute(new Runnable(){

            @Override
            public void run() {
                semaphore.countDown();
            }
        });
        l.await();
        final CountDownLatch started = new CountDownLatch(1);
        platform.work(new CheckedRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        logger.debug("about to hang forever ...");
                        Thread.sleep(1000L);
                        logger.debug("count down to mark started ...");
                        started.countDown();
                        this.wait();
                    }
                    catch (InterruptedException err) {
                        interrupted.countDown();
                    }
                }
            }
        });
        started.await();
        platform.dispose();
        interrupted.await();
    }
}

