/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.ups.PlainServiceInfo;
import com.turbospaces.ups.RawServiceInfo;
import com.turbospaces.ups.UPSs;
import java.time.Duration;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.service.BaseServiceInfo;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.cloud.service.common.PostgresqlServiceInfo;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;

public class UpssTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void works() throws Exception {
        final String ups = UUID.randomUUID().toString();
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        final SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.run(new String[0]);
        try {
            try {
                bootstrap.serviceInfoByName(ups).blockFirst(Duration.ofMillis(1L));
                Assertions.fail();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            Scheduler scheduler = bootstrap.globalPlatform().scheduler();
            final CountDownLatch latch = new CountDownLatch(1);
            bootstrap.serviceInfoByName(ups).subscribeOn(scheduler).subscribe((Consumer)new Consumer<ServiceInfo>(){

                @Override
                public void accept(ServiceInfo t) {
                    latch.countDown();
                }
            });
            final CountDownLatch executed = new CountDownLatch(1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(ups));
                    executed.countDown();
                }
            }).start();
            executed.await();
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
            Assertions.assertNotNull((Object)bootstrap.cloud().getServiceInfo(ups));
            bootstrap.removeUps(ups);
            Assertions.assertTrue((boolean)bootstrap.cloud().getServiceInfos().isEmpty());
            try {
                bootstrap.serviceInfoByName(ups).timeout(Duration.ofMillis(1L)).hasElements().block();
                Assertions.fail();
            }
            catch (Exception err) {
                Assertions.assertTrue((boolean)ExceptionUtils.getRootCause((Throwable)err).getClass().equals(TimeoutException.class));
            }
        }
        finally {
            bootstrap.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scoped() throws Exception {
        final String scope = Long.toString(System.currentTimeMillis());
        final String ups = UUID.randomUUID().toString();
        final UUID uuid = UUID.randomUUID();
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        final SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.run(new String[0]);
        try {
            try {
                bootstrap.scopedServiceInfoByName(scope, ups).blockFirst(Duration.ofMillis(1L));
                Assertions.fail();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            Scheduler scheduler = bootstrap.globalPlatform().scheduler();
            final CountDownLatch latch = new CountDownLatch(2);
            bootstrap.scopedServiceInfoByName(scope, ups).subscribeOn(scheduler).subscribe((Consumer)new Consumer<ServiceInfo>(){

                @Override
                public void accept(ServiceInfo t) {
                    latch.countDown();
                }
            });
            final CountDownLatch executed = new CountDownLatch(1);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(ups));
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(uuid + "-" + ups));
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(scope + "-" + ups));
                    executed.countDown();
                }
            }).start();
            executed.await();
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
            Assertions.assertNotNull((Object)bootstrap.cloud().getServiceInfo(ups));
            Assertions.assertNotNull((Object)bootstrap.cloud().getServiceInfo(scope + "-" + ups));
            bootstrap.removeUps(ups);
            bootstrap.removeUps(scope + "-" + ups);
            bootstrap.removeUps(uuid + "-" + ups);
            Assertions.assertTrue((boolean)bootstrap.cloud().getServiceInfos().isEmpty());
            try {
                bootstrap.serviceInfoByName(ups).timeout(Duration.ofMillis(1L)).hasElements().block();
                Assertions.fail();
            }
            catch (Exception err) {
                Assertions.assertTrue((boolean)ExceptionUtils.getRootCause((Throwable)err).getClass().equals(TimeoutException.class));
            }
        }
        finally {
            bootstrap.shutdown();
        }
    }

    @Test
    public void plainServiceInfo() {
        PlainServiceInfo si1 = new PlainServiceInfo("key", "https://a.b/c?d=e");
        PlainServiceInfo si2 = new PlainServiceInfo("key", "https://a.b/c?d=e1&d=e2");
        PlainServiceInfo si3 = new PlainServiceInfo("key", "https://a.b?d=e");
        Flux flux = Flux.fromIterable(Arrays.asList(si1, si1, si1, si2, si3)).log().distinctUntilChanged(Function.identity(), UPSs::isEquals).distinctUntilChanged(Function.identity(), (s1, s2) -> UPSs.hashCode((ServiceInfo)s1) == UPSs.hashCode((ServiceInfo)s2));
        final AtomicLong l = new AtomicLong();
        flux.subscribe((Consumer)new Consumer<PlainServiceInfo>(){

            @Override
            public void accept(PlainServiceInfo t) {
                UpssTest.this.logger.info("accepting UPS: {}", (Object)t);
                l.incrementAndGet();
            }
        });
        flux.subscribe();
        Assertions.assertEquals((long)3L, (long)l.get());
    }

    @Test
    public void rawServiceInfo() {
        RawServiceInfo si1 = new RawServiceInfo("key", "a".getBytes());
        RawServiceInfo si2 = new RawServiceInfo("key", "b".getBytes());
        RawServiceInfo si3 = new RawServiceInfo("key", "c".getBytes());
        Flux flux = Flux.fromIterable(Arrays.asList(si1, si1, si1, si2, si2, si3)).log().distinctUntilChanged(Function.identity(), UPSs::isEquals).distinctUntilChanged(Function.identity(), (s1, s2) -> UPSs.hashCode((ServiceInfo)s1) == UPSs.hashCode((ServiceInfo)s2));
        final AtomicLong l = new AtomicLong();
        flux.subscribe((Consumer)new Consumer<RawServiceInfo>(){

            @Override
            public void accept(RawServiceInfo t) {
                UpssTest.this.logger.info("accepting UPS: {}", (Object)t.getId());
                l.incrementAndGet();
            }
        });
        flux.subscribe();
        Assertions.assertEquals((long)3L, (long)l.get());
    }

    @Test
    public void pg() {
        PostgresqlServiceInfo si1 = new PostgresqlServiceInfo("key", "postgres://app_owner:app_owner@127.0.0.1:5432/defaultdb1");
        PostgresqlServiceInfo si2 = new PostgresqlServiceInfo("key", "postgres://app_owner:app_owner2@127.0.0.1:5432/defaultdb");
        PostgresqlServiceInfo si3 = new PostgresqlServiceInfo("key", "postgres://app_owner:app_owner@127.0.0.3:5432/defaultdb");
        Flux flux = Flux.fromIterable(Arrays.asList(si1, si1, si1, si2, si2, si3)).log().distinctUntilChanged(Function.identity(), UPSs::isEquals).distinctUntilChanged(Function.identity(), (s1, s2) -> UPSs.hashCode((ServiceInfo)s1) == UPSs.hashCode((ServiceInfo)s2));
        final AtomicLong l = new AtomicLong();
        flux.subscribe((Consumer)new Consumer<PostgresqlServiceInfo>(){

            @Override
            public void accept(PostgresqlServiceInfo t) {
                UpssTest.this.logger.info("accepting UPS: {}", (Object)t.getId());
                l.incrementAndGet();
            }
        });
        flux.subscribe();
        Assertions.assertEquals((long)3L, (long)l.get());
    }
}

