/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationProperties;
import io.vavr.CheckedRunnable;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import javax.inject.Inject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.boot.BootstrapContextClosedEvent;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;

public class MockBootstrap
extends SimpleBootstrap {
    public MockBootstrap(ApplicationProperties props, Class<?> ... mainClass) throws Exception {
        super(props, (Class[])mainClass);
    }

    protected void doStart(String ... args) throws Throwable {
        this.addBootstrapRegistryInitializer(new HttpClientPlugin());
        super.doStart(new String[0]);
    }

    public static class InboundChannel
    extends AbstractBootstrapAware
    implements SmartLifecycle {
        private final URI uri;
        private final ServerBootstrap http;
        private HttpServer channel;
        private boolean running;
        @Inject
        private CloseableHttpClient httpClient;

        public InboundChannel(URI uri) {
            this.uri = Objects.requireNonNull(uri);
            this.http = ServerBootstrap.bootstrap();
        }

        public void start() {
            try {
                this.http.setListenerPort(this.bootstrap.port());
                this.http.setHandlerMapper(new HttpRequestHandlerMapper(){

                    public HttpRequestHandler lookup(HttpRequest request) {
                        return new HttpRequestHandler(){

                            public void handle(HttpRequest req, HttpResponse resp, HttpContext context) throws HttpException, IOException {
                                String reqUri = req.getRequestLine().getUri();
                                if (reqUri.equals(uri.getPath())) {
                                    resp.setStatusCode(200);
                                    resp.setEntity((HttpEntity)new StringEntity(req.toString(), ContentType.APPLICATION_JSON));
                                } else {
                                    resp.setStatusCode(404);
                                }
                            }
                        };
                    }
                });
                this.logger.debug("Starting embedded Http server: {}", (Object)this.bootstrap.port());
                this.channel = this.http.create();
                this.channel.start();
                this.running = true;
                HttpGet req = new HttpGet();
                req.setURI(this.uri);
                final CountDownLatch latch = new CountDownLatch(1);
                try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)req);){
                    final String text = EntityUtils.toString((HttpEntity)resp.getEntity());
                    this.bootstrap.globalPlatform().work(new CheckedRunnable(){

                        public void run() throws Exception {
                            logger.debug(text);
                            latch.countDown();
                        }
                    });
                }
                latch.await();
            }
            catch (Exception err) {
                throw new BeanInitializationException(err.getMessage(), (Throwable)err);
            }
        }

        public void stop(Runnable callback) {
            if (this.channel != null) {
                this.stop();
                callback.run();
            }
        }

        public void stop() {
            this.logger.debug("Stoppping embedded Http server");
            this.channel.stop();
            this.running = false;
        }

        public boolean isRunning() {
            return this.running;
        }
    }

    public static class HttpClientPlugin
    implements BootstrapRegistryInitializer {
        public void initialize(final BootstrapRegistry registry) {
            registry.register(HttpClientBuilder.class, BootstrapRegistry.InstanceSupplier.of((Object)HttpClients.custom()));
            registry.addCloseListener((ApplicationListener)new ApplicationListener<BootstrapContextClosedEvent>(){

                public void onApplicationEvent(BootstrapContextClosedEvent event) {
                    HttpClientBuilder builder = (HttpClientBuilder)registry.getRegisteredInstanceSupplier(HttpClientBuilder.class).get(event.getBootstrapContext());
                    ConfigurableApplicationContext ctx = event.getApplicationContext();
                    ctx.getBeanFactory().registerSingleton("http-client-factory", (Object)builder);
                }
            });
        }
    }
}

