/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.cfg;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.reflect.TypeToken;
import com.netflix.archaius.api.Property;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.CloudOptions;
import com.turbospaces.cfg.DynamicPropertyFactory;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.URL;
import java.time.Duration;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.scheduler.Scheduler;
import reactor.util.retry.Retry;

public interface TypedPropertyFactory {
    public static final String APPLICATION_PROPERTIES = "application.properties";

    public DynamicPropertyFactory factory();

    public String externalIp();

    public Retry retry(Scheduler var1);

    public boolean warnInconsistency(String ... var1) throws Exception;

    default public ApplicationConfig cfg() {
        return this.factory().getConfig();
    }

    default public Property<List<Integer>> listOfInts(String key) {
        TypeToken<List<Integer>> type = new TypeToken<List<Integer>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast);
    }

    default public Property<List<Long>> listOfLongs(String key) {
        TypeToken<List<Long>> type = new TypeToken<List<Long>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast);
    }

    default public Property<List<String>> listOfStrings(String key) {
        TypeToken<List<String>> type = new TypeToken<List<String>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast);
    }

    default public Property<List<Double>> listOfDoubles(String key) {
        TypeToken<List<Double>> type = new TypeToken<List<Double>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast);
    }

    default public Property<List<BigDecimal>> listOfBigDecimals(String key) {
        TypeToken<List<BigDecimal>> type = new TypeToken<List<BigDecimal>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast);
    }

    default public Property<Set<LocalDate>> setOfLocalDates(String key) {
        TypeToken<Set<LocalDate>> type = new TypeToken<Set<LocalDate>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast);
    }

    default public Property<Set<Pattern>> setOfPatterns(String key) {
        TypeToken<Set<Pattern>> type = new TypeToken<Set<Pattern>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast);
    }

    default public Property<Set<Integer>> setOfInts(String key) {
        TypeToken<Set<Integer>> type = new TypeToken<Set<Integer>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast);
    }

    default public Property<Set<Long>> setOfLongs(String key) {
        TypeToken<Set<Long>> type = new TypeToken<Set<Long>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast);
    }

    default public Property<Set<String>> setOfStrings(String key) {
        TypeToken<Set<String>> type = new TypeToken<Set<String>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast);
    }

    default public Property<Set<Double>> setOfDoubles(String key) {
        TypeToken<Set<Double>> type = new TypeToken<Set<Double>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast);
    }

    default public Property<Set<BigDecimal>> setOfBigDecimals(String key) {
        TypeToken<Set<BigDecimal>> type = new TypeToken<Set<BigDecimal>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast);
    }

    default public Property<List<LocalDate>> listOfLocalDates(String key) {
        TypeToken<List<LocalDate>> type = new TypeToken<List<LocalDate>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast);
    }

    default public Property<List<Pattern>> listOfPatterns(String key) {
        TypeToken<List<Pattern>> type = new TypeToken<List<Pattern>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast);
    }

    default public Property<Map<String, String>> mapOfStringStrings(String key) {
        TypeToken<Map<String, String>> type = new TypeToken<Map<String, String>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast).orElse(Collections.emptyMap());
    }

    default public Property<Map<String, Integer>> mapOfStringInts(String key) {
        TypeToken<Map<String, Integer>> type = new TypeToken<Map<String, Integer>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast).orElse(Collections.emptyMap());
    }

    default public Property<Map<String, Long>> mapOfStringLongs(String key) {
        TypeToken<Map<String, Long>> type = new TypeToken<Map<String, Long>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast).orElse(Collections.emptyMap());
    }

    default public Property<Map<String, Double>> mapOfStringDoubles(String key) {
        TypeToken<Map<String, Double>> type = new TypeToken<Map<String, Double>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast).orElse(Collections.emptyMap());
    }

    default public Property<Map<String, BigDecimal>> mapOfStringBigDecimals(String key) {
        TypeToken<Map<String, BigDecimal>> type = new TypeToken<Map<String, BigDecimal>>(){};
        Class rawType = type.getRawType();
        return this.factory().get(key, type.getType()).map(rawType::cast).orElse(Collections.emptyMap());
    }

    default public Property<Duration> rangeValue(String key, Duration defaultValue, final Range<Duration> boundary) {
        final Logger logger = LoggerFactory.getLogger(this.getClass());
        final Property prop = this.factory().get(key, Duration.class).orElse((Object)defaultValue);
        if (Objects.nonNull(boundary)) {
            prop.subscribe((Consumer)new Consumer<Duration>(){

                @Override
                public void accept(Duration t) {
                    if (Objects.nonNull(t) && boundary.contains((Comparable)t)) {
                        logger.error("property: {} is out of range: {}, new value: {}", new Object[]{prop.getKey(), boundary, t});
                    }
                }
            });
            logger.debug("subscribed to: {} and will monitor value of range: {}", (Object)prop.getKey(), boundary);
        }
        return prop;
    }

    default public void analyze(URL url) throws Exception {
        Map<String, Object> map = this.readFieldAsMap();
        Properties table = new Properties();
        try (InputStream io = url.openStream();){
            table.load(io);
        }
        for (Map.Entry<Object, Object> it : table.entrySet()) {
            String key = it.getKey().toString();
            String value = it.getValue().toString();
            if (BooleanUtils.isFalse((Boolean)map.containsKey(key))) {
                System.err.println(String.format("unknown: %s", key));
                continue;
            }
            String toString = Objects.toString(map.get(key));
            if (!Objects.equals(toString, value)) continue;
            System.out.println(String.format("toRemove: %s", key));
        }
    }

    default public Map<String, Object> readFieldAsMap() throws IllegalAccessException {
        HashMap map = Maps.newHashMap();
        for (Field f : FieldUtils.getAllFields(this.getClass())) {
            if (!Modifier.isPublic(f.getModifiers()) || !BooleanUtils.isFalse((Boolean)Modifier.isStatic(f.getModifiers()))) continue;
            Property prop = (Property)FieldUtils.readField((Field)f, (Object)this);
            String key = prop.getKey();
            Object value = prop.get();
            map.put(key, value);
        }
        Arrays.asList(FieldUtils.getAllFields(CloudOptions.class)).stream().map(Field::getName).forEach(map::remove);
        return map;
    }

    default public void putValueIfPresent(String key, ImmutableMap.Builder<String, String> map) {
        if (this.factory().getConfig().containsKey(key)) {
            String raw = Objects.requireNonNull(this.factory().getConfig().getString(key));
            map.put((Object)key, (Object)raw);
        }
    }

    default public void putValue(String key, ImmutableMap.Builder<String, String> map, String defaultValue) {
        if (this.factory().getConfig().containsKey(key)) {
            String raw = Objects.requireNonNull(this.factory().getConfig().getString(key));
            map.put((Object)key, (Object)raw);
        } else {
            map.put((Object)key, (Object)Objects.requireNonNull(defaultValue));
        }
    }
}

