package com.turbospaces.boot;

import java.time.Duration;
import java.util.concurrent.CountDownLatch;

import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;

import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.vavr.CheckedRunnable;

public class ConfigurablePlatformTest {
    @Test
    public void works() throws Exception {
        Logger logger = LoggerFactory.getLogger(getClass());
        ApplicationConfig cfg = ApplicationConfig.create(Duration.ofDays(1));
        ApplicationProperties props = new ApplicationProperties(cfg);

        cfg.setLocalProperty(props.APP_PLATFORM_GRACEFUL_SHUTDOWN_TIMEOUT.getKey(), Duration.ofSeconds(1));

        SimpleMeterRegistry registry = new SimpleMeterRegistry();
        ExecutionPlatform platform = new ConfigurablePlatform("test", new ApplicationProperties(cfg), registry);
        CountDownLatch semaphore = new CountDownLatch(1);
        CountDownLatch l = new CountDownLatch(1);
        CountDownLatch interrupted = new CountDownLatch(1);
        platform.work(new CheckedRunnable() {
            @Override
            public void run() throws Exception {
                System.out.println("work");
                semaphore.await();
                l.countDown();
            }
        });
        platform.execute(new Runnable() {
            @Override
            public void run() {
                System.out.println("execute");
                semaphore.countDown();
            }
        });
        l.await();
        CountDownLatch started = new CountDownLatch(1);
        platform.work(new CheckedRunnable() {
            @Override
            public void run() {
                synchronized (this) {
                    try {
                        logger.debug("about to hang forever ...");
                        Thread.sleep(1000);
                        logger.debug("count down to mark started ...");
                        started.countDown();
                        wait();
                    } catch (InterruptedException err) {
                        interrupted.countDown();
                    }
                }
            }
        });
        started.await();
        platform.dispose();
        interrupted.await();
    }
}
