/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common;

import com.turbospaces.common.RequestReplyMapper;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CompletableRequestReplyMapper<K, V>
implements RequestReplyMapper<K, V> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<K, CompletableFuture<V>> corr = new ConcurrentHashMap<K, CompletableFuture<V>>();
    private final Timer timer = new Timer(true);

    @Override
    public CompletableFuture<V> acquire(final K key, final int timeout, final TimeUnit unit) {
        boolean duplicate;
        final CompletableFuture f = new CompletableFuture();
        final long now = System.currentTimeMillis();
        f.whenComplete(new BiConsumer<V, Throwable>(){

            @Override
            public void accept(V resp, Throwable err) {
                if (err != null) {
                    CompletableFuture promise = (CompletableFuture)CompletableRequestReplyMapper.this.corr.remove(key);
                    if (promise != null && err instanceof TimeoutException) {
                        CompletableRequestReplyMapper.this.logger.debug("request-reply(m={}) removing subj due to timeout", key);
                    }
                } else {
                    CompletableRequestReplyMapper.this.logger.debug("request-reply(m={}) completed in {} 'ms'", key, (Object)(System.currentTimeMillis() - now));
                }
            }
        });
        boolean bl = duplicate = this.corr.putIfAbsent(key, f) != null;
        if (duplicate) {
            throw new RuntimeException("duplicate key violation corrId: " + key);
        }
        final Map mdc = MDC.getCopyOfContextMap();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!f.isDone()) {
                    if (mdc != null) {
                        MDC.setContextMap((Map)mdc);
                    }
                    try {
                        String msg = String.format("no response in %s%s for %s", timeout, unit.toString().toLowerCase(), key);
                        TimeoutException timeoutException = new TimeoutException(msg);
                        f.completeExceptionally(timeoutException);
                    }
                    finally {
                        MDC.clear();
                    }
                }
            }
        }, unit.toMillis(timeout));
        return f;
    }

    @Override
    public void complete(K key, V value) {
        CompletableFuture subj = (CompletableFuture)this.corr.remove(Objects.requireNonNull(key));
        if (subj != null) {
            subj.complete(value);
        } else {
            this.logger.trace("no such correlation for key: {}", key);
        }
    }

    @Override
    public void completeExceptionally(K key, Throwable reason) {
        CompletableFuture subj = (CompletableFuture)this.corr.remove(Objects.requireNonNull(key));
        if (subj != null) {
            subj.completeExceptionally(reason);
        }
    }

    @Override
    public void completeExceptionally(Throwable reason) {
        for (CompletableFuture f : this.corr.values()) {
            f.completeExceptionally(reason);
        }
    }

    @Override
    public void clear() {
        this.corr.clear();
    }

    @Override
    public int pendingCount() {
        return this.corr.size();
    }
}

