/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ups;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.ups.RawServiceInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.springframework.cloud.service.BaseServiceInfo;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.cloud.service.UriBasedServiceInfo;
import reactor.core.publisher.Flux;

public interface UPSs {
    public static final String CFG = "cfg";
    public static final String SENTRY = "sentry";
    public static final String ELASTIC_SEARCH = "elastic-search";
    public static final String INFLUX = "influx";
    public static final String JAEGER = "jaeger";
    public static final String KAFKA = "kafka";
    public static final String POSTGRES_OWNER = "postgres-owner";
    public static final String H2_OWNER = "h2-owner";
    public static final String POSTGRES_APP = "postgres-app";
    public static final String H2_APP = "h2-app";
    public static final String QUARTZ_APP = "quartz-app";

    public <T extends ServiceInfo> Flux<ServiceInfo> serviceInfoByName(String var1);

    public <T extends ServiceInfo> Flux<ServiceInfo> scopedServiceInfoByName(String var1, String var2);

    public static <T extends ServiceInfo> Optional<T> findServiceInfoByName(Bootstrap boot, final String name) {
        List<ServiceInfo> serviceInfos = boot.cloud().getServiceInfos();
        return serviceInfos.stream().filter(new Predicate<ServiceInfo>(){

            @Override
            public boolean test(ServiceInfo input) {
                return input.getId().equals(name);
            }
        }).findAny();
    }

    public static <T extends ServiceInfo> T findRequiredServiceInfoByName(Bootstrap bootstrap, String name) {
        return (T)((ServiceInfo)UPSs.findServiceInfoByName(bootstrap, name).get());
    }

    public static <T extends ServiceInfo> Optional<T> findScopedServiceInfoByName(String scope, Bootstrap bootstrap, String name) {
        Optional<T> opt = UPSs.findServiceInfoByName(bootstrap, String.format("%s-%s", scope, name));
        if (opt.isPresent()) {
            return opt;
        }
        opt = UPSs.findServiceInfoByName(bootstrap, name);
        return opt;
    }

    public static <T extends ServiceInfo> T findScopedRequiredServiceInfoByName(String scope, Bootstrap bootstrap, String name) {
        Optional<T> opt = UPSs.findServiceInfoByName(bootstrap, String.format("%s-%s", scope, name));
        if (opt.isPresent()) {
            return (T)((ServiceInfo)opt.get());
        }
        opt = UPSs.findServiceInfoByName(bootstrap, name);
        return (T)((ServiceInfo)opt.get());
    }

    public static boolean isEquals(ServiceInfo t, ServiceInfo u) {
        if (t.getClass().equals(u.getClass())) {
            if (t instanceof UriBasedServiceInfo && u instanceof UriBasedServiceInfo) {
                UriBasedServiceInfo turi = (UriBasedServiceInfo)t;
                UriBasedServiceInfo uuri = (UriBasedServiceInfo)u;
                return new EqualsBuilder().append((Object)turi.getId(), (Object)uuri.getId()).append((Object)turi.getUri(), (Object)uuri.getUri()).isEquals();
            }
            if (t instanceof RawServiceInfo && u instanceof RawServiceInfo) {
                RawServiceInfo turi = (RawServiceInfo)t;
                RawServiceInfo uuri = (RawServiceInfo)u;
                return new EqualsBuilder().append((Object)turi.getId(), (Object)uuri.getId()).append(turi.getPayload(), uuri.getPayload()).isEquals();
            }
            if (t instanceof BaseServiceInfo && u instanceof BaseServiceInfo) {
                BaseServiceInfo turi = (BaseServiceInfo)t;
                BaseServiceInfo uuri = (BaseServiceInfo)u;
                return Objects.equals(turi.getId(), uuri.getId());
            }
            throw new UnsupportedOperationException("don't know how to compare " + t.getClass().getSimpleName());
        }
        return false;
    }

    public static int hashCode(ServiceInfo si) {
        if (si instanceof UriBasedServiceInfo) {
            UriBasedServiceInfo usi = (UriBasedServiceInfo)si;
            return Objects.hash(usi.getId(), usi.getUri());
        }
        if (si instanceof RawServiceInfo) {
            RawServiceInfo rsi = (RawServiceInfo)si;
            return Objects.hash(rsi.getId(), Arrays.hashCode(rsi.getPayload()));
        }
        if (si instanceof BaseServiceInfo) {
            BaseServiceInfo bsi = (BaseServiceInfo)si;
            return Objects.hash(bsi.getId());
        }
        throw new UnsupportedOperationException("don't know how to calculate hashcode " + si.getClass().getSimpleName());
    }
}

