/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.turbospaces.boot.ExecutionPlatform;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import io.vavr.CheckedRunnable;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractPlatform
implements ExecutionPlatform {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ApplicationProperties props;

    public AbstractPlatform(ApplicationProperties props) {
        this.props = Objects.requireNonNull(props);
    }

    @Override
    public void shutdown() {
        this.executor().shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor().shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executor().isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor().isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor().awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor().submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor().submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executor().submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executor().invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor().invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executor().invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executor().invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(final Runnable command) {
        final Map mdc = MDC.getCopyOfContextMap();
        if (mdc == null) {
            this.executor().execute(command);
        } else {
            this.executor().execute(new Runnable(){

                @Override
                public void run() {
                    MDC.setContextMap((Map)mdc);
                    try {
                        command.run();
                    }
                    catch (Throwable err) {
                        AbstractPlatform.this.logger.error(err.getMessage(), err);
                    }
                    finally {
                        MDC.clear();
                    }
                }
            });
        }
    }

    @Override
    public void work(final CheckedRunnable action) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    action.run();
                }
                catch (Throwable err) {
                    AbstractPlatform.this.logger.error(err.getMessage(), err);
                }
            }
        });
    }

    public void dispose() {
        Duration timeout = (Duration)this.props.APP_PLATFORM_GRACEFUL_SHUTDOWN_TIMEOUT.get();
        PlatformUtil.shutdownExecutor(this.executor(), timeout);
        this.logger.debug("stopped platform-worker pool ...");
    }
}

