/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ups;

import com.turbospaces.boot.Bootstrap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.cloud.service.ServiceInfo;
import reactor.core.publisher.Flux;

public interface UPSs {
    public static final String CFG = "cfg";
    public static final String SENTRY = "sentry";
    public static final String ELASTIC_SEARCH = "elastic-search";
    public static final String INFLUX = "influx";
    public static final String JAEGER = "jaeger";
    public static final String KAFKA = "kafka";
    public static final String POSTGRES_OWNER = "postgres-owner";
    public static final String H2_OWNER = "h2-owner";
    public static final String POSTGRES_APP = "postgres-app";
    public static final String H2_APP = "h2-app";
    public static final String QUARTZ_APP = "quartz-app";

    public <T extends ServiceInfo> Flux<ServiceInfo> serviceInfoByName(String var1);

    public <T extends ServiceInfo> Flux<ServiceInfo> scopedServiceInfoByName(String var1, String var2);

    public static <T extends ServiceInfo> Optional<T> findServiceInfoByName(Bootstrap boot, final String name) {
        List<ServiceInfo> serviceInfos = boot.cloud().getServiceInfos();
        return serviceInfos.stream().filter(new Predicate<ServiceInfo>(){

            @Override
            public boolean test(ServiceInfo input) {
                return input.getId().equals(name);
            }
        }).findAny();
    }

    public static <T extends ServiceInfo> T findRequiredServiceInfoByName(Bootstrap bootstrap, String name) {
        return (T)((ServiceInfo)UPSs.findServiceInfoByName(bootstrap, name).get());
    }

    public static <T extends ServiceInfo> Optional<T> findScopedServiceInfoByName(String scope, Bootstrap bootstrap, String name) {
        Optional<T> opt = UPSs.findServiceInfoByName(bootstrap, String.format("%s-%s", scope, name));
        if (opt.isPresent()) {
            return opt;
        }
        opt = UPSs.findServiceInfoByName(bootstrap, name);
        return opt;
    }

    public static <T extends ServiceInfo> T findScopedRequiredServiceInfoByName(String scope, Bootstrap bootstrap, String name) {
        Optional<T> opt = UPSs.findServiceInfoByName(bootstrap, String.format("%s-%s", scope, name));
        if (opt.isPresent()) {
            return (T)((ServiceInfo)opt.get());
        }
        opt = UPSs.findServiceInfoByName(bootstrap, name);
        return (T)((ServiceInfo)opt.get());
    }
}

