package com.turbospaces.boot;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.service.BaseServiceInfo;
import org.springframework.cloud.service.ServiceInfo;

import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;

import reactor.core.scheduler.Scheduler;

public class UpssTest {
    @Test
    public void works() throws Exception {
        String ups = UUID.randomUUID().toString();

        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.run();

        try {
            try {
                bootstrap.serviceInfoByName(ups).blockFirst(Duration.ofMillis(1));
                Assertions.fail();
            } catch (RuntimeException err) {

            }

            Scheduler scheduler = bootstrap.globalPlatform().scheduler();
            CountDownLatch latch = new CountDownLatch(1);
            bootstrap.serviceInfoByName(ups).subscribeOn(scheduler).subscribe(new Consumer<ServiceInfo>() {
                @Override
                public void accept(ServiceInfo t) {
                    latch.countDown();
                }
            });

            new Thread(new Runnable() {
                @Override
                public void run() {
                    bootstrap.addUps(new BaseServiceInfo(ups));
                }
            }).start();

            Assertions.assertTrue(latch.await(1, TimeUnit.MINUTES));
            Assertions.assertNotNull(bootstrap.cloud().getServiceInfo(ups));

            bootstrap.removeUps(ups);
            Assertions.assertTrue(bootstrap.cloud().getServiceInfos().isEmpty());

            try {
                bootstrap.serviceInfoByName(ups).timeout(Duration.ofMillis(1)).hasElements().block();
                Assertions.fail();
            } catch (Exception err) {
                Assertions.assertTrue(ExceptionUtils.getRootCause(err).getClass().equals(TimeoutException.class));
            }
        } finally {
            bootstrap.shutdown();
        }
    }
    @Test
    public void scoped() throws Exception {
        String scope = Long.toString(System.currentTimeMillis());
        String ups = UUID.randomUUID().toString();
        UUID uuid = UUID.randomUUID();

        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.run();

        try {
            try {
                bootstrap.scopedServiceInfoByName(scope, ups).blockFirst(Duration.ofMillis(1));
                Assertions.fail();
            } catch (RuntimeException err) {

            }

            Scheduler scheduler = bootstrap.globalPlatform().scheduler();
            CountDownLatch latch = new CountDownLatch(2);
            bootstrap.scopedServiceInfoByName(scope, ups).subscribeOn(scheduler).subscribe(new Consumer<ServiceInfo>() {
                @Override
                public void accept(ServiceInfo t) {
                    latch.countDown();
                }
            });

            new Thread(new Runnable() {
                @Override
                public void run() {
                    bootstrap.addUps(new BaseServiceInfo(ups));
                    bootstrap.addUps(new BaseServiceInfo(uuid + "-" + ups));
                    bootstrap.addUps(new BaseServiceInfo(scope + "-" + ups));
                }
            }).start();

            Assertions.assertTrue(latch.await(1, TimeUnit.MINUTES));
            Assertions.assertNotNull(bootstrap.cloud().getServiceInfo(ups));
            Assertions.assertNotNull(bootstrap.cloud().getServiceInfo(scope + "-" + ups));

            bootstrap.removeUps(ups);
            bootstrap.removeUps(scope + "-" + ups);
            bootstrap.removeUps(uuid + "-" + ups);
            Assertions.assertTrue(bootstrap.cloud().getServiceInfos().isEmpty());

            try {
                bootstrap.serviceInfoByName(ups).timeout(Duration.ofMillis(1)).hasElements().block();
                Assertions.fail();
            } catch (Exception err) {
                Assertions.assertTrue(ExceptionUtils.getRootCause(err).getClass().equals(TimeoutException.class));
            }
        } finally {
            bootstrap.shutdown();
        }
    }
}
