/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.service.BaseServiceInfo;
import org.springframework.cloud.service.ServiceInfo;
import reactor.core.scheduler.Scheduler;

public class UpssTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void works() throws Exception {
        final String ups = UUID.randomUUID().toString();
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        final SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.run(new String[0]);
        try {
            try {
                bootstrap.serviceInfoByName(ups).blockFirst(Duration.ofMillis(1L));
                Assertions.fail();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            Scheduler scheduler = bootstrap.globalPlatform().scheduler();
            final CountDownLatch latch = new CountDownLatch(1);
            bootstrap.serviceInfoByName(ups).subscribeOn(scheduler).subscribe((Consumer)new Consumer<ServiceInfo>(){

                @Override
                public void accept(ServiceInfo t) {
                    latch.countDown();
                }
            });
            new Thread(new Runnable(){

                @Override
                public void run() {
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(ups));
                }
            }).start();
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
            Assertions.assertNotNull((Object)bootstrap.cloud().getServiceInfo(ups));
            bootstrap.removeUps(ups);
            Assertions.assertTrue((boolean)bootstrap.cloud().getServiceInfos().isEmpty());
            try {
                bootstrap.serviceInfoByName(ups).timeout(Duration.ofMillis(1L)).hasElements().block();
                Assertions.fail();
            }
            catch (Exception err) {
                Assertions.assertTrue((boolean)ExceptionUtils.getRootCause((Throwable)err).getClass().equals(TimeoutException.class));
            }
        }
        finally {
            bootstrap.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void scoped() throws Exception {
        final String scope = Long.toString(System.currentTimeMillis());
        final String ups = UUID.randomUUID().toString();
        final UUID uuid = UUID.randomUUID();
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        final SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.run(new String[0]);
        try {
            try {
                bootstrap.scopedServiceInfoByName(scope, ups).blockFirst(Duration.ofMillis(1L));
                Assertions.fail();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            Scheduler scheduler = bootstrap.globalPlatform().scheduler();
            final CountDownLatch latch = new CountDownLatch(2);
            bootstrap.scopedServiceInfoByName(scope, ups).subscribeOn(scheduler).subscribe((Consumer)new Consumer<ServiceInfo>(){

                @Override
                public void accept(ServiceInfo t) {
                    latch.countDown();
                }
            });
            new Thread(new Runnable(){

                @Override
                public void run() {
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(ups));
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(uuid + "-" + ups));
                    bootstrap.addUps((ServiceInfo)new BaseServiceInfo(scope + "-" + ups));
                }
            }).start();
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
            Assertions.assertNotNull((Object)bootstrap.cloud().getServiceInfo(ups));
            Assertions.assertNotNull((Object)bootstrap.cloud().getServiceInfo(scope + "-" + ups));
            bootstrap.removeUps(ups);
            bootstrap.removeUps(scope + "-" + ups);
            bootstrap.removeUps(uuid + "-" + ups);
            Assertions.assertTrue((boolean)bootstrap.cloud().getServiceInfos().isEmpty());
            try {
                bootstrap.serviceInfoByName(ups).timeout(Duration.ofMillis(1L)).hasElements().block();
                Assertions.fail();
            }
            catch (Exception err) {
                Assertions.assertTrue((boolean)ExceptionUtils.getRootCause((Throwable)err).getClass().equals(TimeoutException.class));
            }
        }
        finally {
            bootstrap.shutdown();
        }
    }
}

